<?php
/**
 * Extension Install File
 * Does the stuff for the specific extensions
 *
 * @package         Sourcerer
 * @version         4.4.10
 *
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2015 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class extensionsInstaller extends NoNumberInstallerInstaller
{
	var $name = 'Sourcerer';
	var $alias = 'sourcerer';

	function install(&$states, &$ext)
	{
		$ext = $this->name . ' (system plugin & editor button plugin)';

		// SYSTEM PLUGIN
		$states[] = $this->installExtension($states, $this->alias, 'System - NoNumber ' . $this->name, 'plugin');

		// EDITOR BUTTON PLUGIN
		$states[] = $this->installExtension($states, $this->alias, 'Button - NoNumber ' . $this->name, 'plugin', array('folder' => 'editors-xtd'));
	}
}
