<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access.
defined('_JEXEC') or die;

use Pagebuilderck\CKController;
use Pagebuilderck\CKFof;

class PagebuilderckControllerLibrary extends CKController {

	function __construct() {
		parent::__construct();
	}

	/**
	 * Load the needed interface
	 * 
	 * @return void
	 */
	public function load() {
		// security check
		CKFof::checkAjaxToken();

		$page = $this->input->get('path', '', 'string');
		if (! $page) return;

		$section = explode('/', $page);
		$section = $section[0];

//		$this->interface = new CKInterface();
		$file = PAGEBUILDERCK_PATH . '/libraries/' . $page;
		$content = file_get_contents($file);
		$json = json_decode($content);

		if (! isset($json->htmlcode)) echo 'error';

		// replace vars to allow data to be moved from another server
		$htmlcode = $json->htmlcode;
		$htmlcode = str_replace("|URIROOT|", \Joomla\CMS\Uri\Uri::root(true), $htmlcode);
		$htmlcode = str_replace("|URIBASE|", PAGEBUILDERCK_URI_ROOT, $htmlcode);
		$htmlcode = str_replace("|PBCK_COMPONENT|", "components/com_pagebuilderck", $htmlcode);
		$htmlcode = str_replace("|PBCK_ADMIN_COMPONENT|", "administrator/components/com_pagebuilderck", $htmlcode);
		$htmlcode = str_replace("|IMPORTFOLDER|", 'administrator/components/com_pagebuilderck/libraries/' . $section, $htmlcode);

		echo $htmlcode;

		exit;
	}
}