<?php
/**
 * @copyright	Copyright (C) 2016 Cedric KEIFLIN alias ced1870
 * http://www.joomlack.fr
 * @license		GNU/GPL
 * */

defined('JPATH_PLATFORM') or die;

class JFormFieldCkstylestoload extends \Joomla\CMS\Form\Field\ListField {

	protected $type = 'ckstylestoload';

	protected function getInput() {
		return parent::getInput();
	}

	protected function getOptions()
	{
		// Initialize variables.
		$options = array();

		// Prepend some default options based on field attributes.
		$options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', '-1', \Joomla\CMS\Language\Text::alt('JOPTION_DO_NOT_USE', preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)));

		// Create a new query object.
		$db = \Joomla\CMS\Factory::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->from('`#__pagebuilderck_styles` AS a');

		// Do not list the trashed items
		$query->where('a.state > -1');
		$db->setQuery($query);
		$styles = $db->loadObjectList();

		// Build the options list from the list of folders.
		if (! empty($styles)) {
			foreach($styles as $style) {
				$options[] = \Joomla\CMS\HTML\HTMLHelper::_('select.option', $style->id, $style->title);
			}
		}

		// Merge any additional options in the XML definition.
		$options = array_merge(parent::getOptions(), $options);

		return $options;
	}
}
