<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

?>
<div class="menustylescustom" data-prefix="accordionicon" data-rule=".ui-accordion-header .pbckicon"></div>
<div id="elementscontainer">
	<div class="menulink" tab="tab_blocstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ACCORDION_EDITION'); ?></div>
	<div class="tab menustyles ckproperty tab_fullscreen" id="tab_blocstyles">
		<?php // echo PagebuilderckHelper::renderEditionButtons(); ?>
		<div id="items_edition_list">
		</div>
		<div onclick="ckAddNewListItem()" class="item_add ckbutton ckbutton-primary"><?php echo \Joomla\CMS\Language\Text::_('CK_ADD_ITEM'); ?></div>
		<div class="clr"></div>
	</div>
	<div class="menulink" tab="tab_iconstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_iconstyles">
		<?php echo $this->menustyles->createIconLight('accordionicon') ?>
		<?php echo $this->menustyles->createIconSvgLight('icon') ?>
		<?php //echo $this->menustyles->createIconOptions('icon') ?>
		<?php echo $this->menustyles->createBackground('icon') ?>
		<?php echo $this->menustyles->createDimensions('icon', true, true) ?>
		<?php echo $this->menustyles->createDecoration('icon') ?>
		<?php echo $this->menustyles->createShadow('icon') ?>
		<?php echo $this->menustyles->createCustom('icon') ?>
	</div>
	<div class="menulink" tab="tab_headingaccordionstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ACCORDION_HEADING_STYLE'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_headingaccordionstyles">
		<?php echo $this->menustyles->createBlocStyles('headingaccordion', 'accordionsck', false, false) ?>
	</div>
	<div class="menulink" tab="tab_activeheadingaccordionstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ACCORDION_ACTIVE_HEADING_STYLE'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_activeheadingaccordionstyles">
		<?php echo $this->menustyles->createBlocStyles('activeheadingaccordion', 'accordionsck', false, false) ?>
	</div>
	<div class="menulink" tab="tab_contentaccordionstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ACCORDION_CONTENT_STYLE'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_contentaccordionstyles">
		<?php echo $this->menustyles->createBlocStyles('contentaccordion', 'accordionsck', false, false) ?>
	</div>
	<div class="clr"></div>
</div>
<div class="clr"></div>
<script language="javascript" type="text/javascript">
var focus = $ck('.editfocus');
function ckLoadEditionPopup() {
	var noactivetabscss = focus.find('.accordionsck').attr('activetab') === 'false' ? ' ckbutton-warning active' : '';
	$ck('#items_edition_list').append('<div><div class="item_setdefault ckbutton'+noactivetabscss+'" onclick="ckSetDefaultEditItem($ck(this).parent())"><span class="icon icon-star"></span> <?php echo \Joomla\CMS\Language\Text::_('CK_SET_DEFAULT_CLOSED', true) ?></div></div>');
	$ck('.accordionsck .itemtitleck', focus).each(function(i, el) {
		// B/C nested addons
		var content = $ck('.accordionsck > div', focus).eq(i);
		if (content.hasClass('itemcontentck') && content.find('.itemcontentck').length) {
			content.removeClass('itemcontentck');
		}

		var itemedition = ckCreateEditItem(i, $ck('#items_edition_list'), $ck(el).text(), ckContentToEditor($ck('.accordionsck .itemcontentck', focus).eq(i).html()), true, $ck('.accordionsck .itemtitleck .iconck', focus).eq(i).html());
		ckMakeEditItemAccordion(itemedition);
		ckLoadEditorOnTheFly('item_content_' + i);
		ckGetItemIcon(i, '.itemtitleck');
	});
	$ck('.item_setdefault').eq((parseInt(focus.find('.accordionsck').attr('activetab'))+1)).addClass('ckbutton-warning').addClass('active');
	ckMakeEditItemsSortable();
	ckFillEditionPopup(focus.attr('id'));
}

/* override the JS function for custom use */
function ckSelectIcon(icon) {
	/*var item = $ck('#items_edition_list .ckfieldfocus');
	if (! item.length) return;
	item.find('.iconck').empty().append(icon);
	var focusIcon = item.find('.iconck');
	// if svg icon, empty the css class
	if (focusIcon.find('svg').length) {
		item.find('.item_icon_edition').val('');
	}
	return focusIcon;*/
	return ckSelectIconFromEdition(icon);
}

function ckMakeEditItemAccordion(el) {
	$ck(el).accordionck({
		header: ".item_toggler",
		collapsible: true,
		active: false,
		heightStyle: "content"
	});
}

function ckAddNewListItem() {
	// add the element in the accordion
	$ck('.accordionsck', focus).append(ckGetNewAccordionItem('Lorem Ipsum ...', '<p>Lorem Ipsum ...</p>'));
	$ck('.accordionsck', focus).accordionck( "refresh" );
	// add the element for edition
	var index = $ck('.accordionsck > .ui-accordion-header', focus).length;
	var itemedition = ckCreateEditItem(index, $ck('#items_edition_list'), 'Lorem Ipsum ...', '<p>Lorem Ipsum ...</p>', true);
	ckMakeEditItemAccordion(itemedition);
	ckLoadEditorOnTheFly('item_content_' + index);
}

function ckGetNewAccordionItem(title, content) {
	var html = '<h3><span class="itemtitleck">'+title+'</span></h3>'
		+'<div>'
		+'<div class="innercontent"></div>'
		+'<div class="accordionck itemcontentck">'
			+content
		+'</div>'
		+'<div class="innercontent"></div>';
		+'</div>'

	return html;
}

function ckBeforeSaveEditionPopup() {
	$ck('.item_content_edition').each(function() {
		var textID = $ck(this).attr('id');
		ckSaveEditorOnTheFly(textID);
//		ckRemoveEditorOnTheFly(textID);
	});
	$ck('#items_edition_list .item_edition:not(.ui-sortable-helper)').each(function(i, el) {
		var $el = $ck(el);
		$ck('.itemtitleck', focus).eq(i).text($el.find('.item_title_edition').val());
		$ck('.itemcontentck', focus).eq(i).html(ckEditorToContent($el.find('.item_content_edition').val()));
		if ($el.find('.iconck').html()) $ck('.itemtitleck', focus).eq(i).prepend('<span class="iconck">' + $el.find('.iconck').html() + '</span>');
		ckSetIconFromEdition(i, $el, focus, '.itemtitleck');
	});
	
	var activetab = false;
	$ck('#popup_editionck .item_edition').each(function(i, el) {
		if ($ck(el).find('.item_setdefault.active').length) {
			activetab = i;
		}
		// since 2.19.0 add nested addons
		if (! $ck('.editfocus > .accordionsck > .ui-accordion-content').eq(i).find('> .innercontent').length) {
			var contentArea = $ck('.editfocus > .accordionsck > .ui-accordion-content').eq(i);
			contentArea.html('<div class="innercontent"></div><div class="itemcontentck">' + contentArea.html() + '</div><div class="innercontent"></div>');
			
		}
	});

	ckAddEditionForNestedAddons('#<?php echo $id; ?>');
	focus.find('.accordionsck').attr('activetab', activetab).accordionck("refresh");
	var vPos = $ck('#iconicon-position button.active').attr('data-position');
	$ck('.editfocus .itemtitleck .pbckicon').css('vertical-align', vPos);
}

function ckSaveInlineEditionPopup() {
	ckBeforeSaveEditionPopup();
}

function ckSetDefaultEditItem(item) {
	$ck('.item_setdefault').removeClass('ckbutton-warning').removeClass('active');
	item.find('.item_setdefault').addClass('ckbutton-warning').addClass('active');
}

function ckBeforeCloseEditionPopup() {
	$ck('.item_content_edition').each(function() {
		ckRemoveEditorOnTheFly($ck(this).attr('id'));
	});
}

function ckBeforeDeleteEditItem(item) {
	var index_item = item.index('.item_edition');
	ckRemoveEditorOnTheFly(item.find('.item_content_edition').attr('id'));
	$ck('.accordionsck > .ui-accordion-header', focus).eq(index_item).find('+ .ui-accordion-content').remove();
	$ck('.accordionsck > .ui-accordion-header', focus).eq(index_item).remove();
	$ck('.accordionsck', focus).accordionck("refresh");
}

function ckUpdatePreviewArea() {
	// var focus = $ck('.editfocus');
	// $ck('#items_edition_list .item_edition:not(.ui-sortable-helper)').each(function(i, el) {
		// $ck('.itemtitleck', focus).eq(i).text($ck(el).find('.item_title_edition').val());
		// $ck('.itemcontentck', focus).eq(i).html($ck(el).find('.item_content_edition').val());
	// });
}

function ckMakeEditItemsSortable() {
	$ck( "#items_edition_list" ).sortable({
		items: ".item_edition",
		helper: "clone",
		// axis: "y",
		handle: "> .item_move",
		forcePlaceholderSize: true,
		tolerance: "pointer",
		placeholder: "placeholderck",
		// zIndex: 9999,
		start: function(e, ui){
			$ck(this).find('.item_content_edition').each(function(){
				if (tinymce.get($ck(this).attr('id'))) {
					ckRemoveEditorOnTheFly($ck(this).attr('id'));
				}
			});
		},
		update: function(e, ui) {
			$ck(this).find('.item_content_edition:not(.ui-sortable-helper)').each(function(){
				ckLoadEditorOnTheFly($ck(this).attr('id'));
			});
			ckUpdatePreviewArea();
			$ck( "#<?php echo $id; ?>_preview_accordion" ).accordionck("refresh");
		}
	});
}

ckInitIconPosition('.editfocus .itemtitleck .pbckicon', '#iconicon-position button');
</script>