<?php
/**
 * @copyright	Copyright (C) 2015 Cédric KEIFLIN alias ced1870
 * https://www.template-creator.com
 * https://www.joomlack.fr
 * @license		GNU/GPL
 * */
 
defined('_JEXEC') or die('Restricted access');
jimport('joomla.event.plugin');

class plgPagebuilderckIcon extends \Joomla\CMS\Plugin\CMSPlugin {

	private $context = 'PLG_PAGEBUILDERCK_ICON';

	private $type = 'icon';

	function __construct(&$subject, $params) {

		parent::__construct($subject, $params);
	}

	/* 
	 * Construct the Menu Item to drag into the interface
	 *
	 * Return Object with item data
	 */
	public function onPagebuilderckAddItemToMenu() {
		// load the language files of the plugin
		$this->loadLanguage();
		// create the menu item
		$menuitem = new stdClass();
		$menuitem->type = $this->type;
		$menuitem->group = 'text';
		$menuitem->title = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_TITLE');
		$menuitem->description = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_DESC');
		$menuitem->image = \Joomla\CMS\Uri\Uri::root(true) . '/plugins/pagebuilderck/icon/assets/images/icon.svg';

		return $menuitem;
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemContentIcon() {
		$input = \Joomla\CMS\Factory::getApplication()->input;
		$id = $input->get('ckid', '', 'string');
		// ckstyle and inner classes are needed to get the styles from the interface
		?>
		<div id="<?php echo $id; ?>" class="cktype" data-type="icon" >
			<div class="tab_blocstyles ckprops" iconalignementcenter="checked" fieldslist="iconalignementleft,iconalignementcenter,iconalignementright,iconalignementjustify"></div>
			<div class="tab_iconstyles ckprops" iconicontype="svg" iconiconsvgsize="40" iconiconsvgstrokewidth="2" iconalignementcenter="checked" fieldslist="iconicontype,iconiconsvgsize,iconiconsvgstrokewidth,iconalignementleft,iconalignementcenter,iconalignementright"></div>
			<div class="ckstyle">
				<style>
					#<?php echo $id; ?> .iconck {
						text-align: center;
					}

					#<?php echo $id; ?> .iconck {
						text-align: center;
					}

					#<?php echo $id; ?> svg * {
						stroke-width: 1.6;
					}

					#<?php echo $id; ?> svg.svgicon-ionicon *, #<?php echo $id; ?> svg.svgicon-fontawesome * {
						stroke-width: 25.6;
					}

					#<?php echo $id; ?> svg {
						width: 40px;
						height: 40px;
					}
				</style>
			</div>
			<div class="iconck">
				<span class="pbckicon" data-path="tabler_photo.svg" data-pos="undefined" style="display:inline-block;">
					<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-photo" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round" style="display: inline-block;">
						<line x1="15" y1="8" x2="15.01" y2="8"></line>
						<rect x="4" y="4" width="16" height="16" rx="3"></rect>
						<path d="M4 15l4 -4a3 5 0 0 1 3 0l5 5"></path>
						<path d="M14 14l1 -1a3 5 0 0 1 3 0l2 2"></path>
					</svg>
				</span>
			</div>
		</div>
		<?php
	}

	/* 
	 * Load the interface for the item edition
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemOptionsIcon() {
		// load the language files of the plugin
		$this->loadLanguage();
		// load the interface for the options
		$tpl = JPATH_SITE . '/plugins/pagebuilderck/icon/layouts/edit_icon.php';
		return $tpl;
	}

	/* 
	 * Display the html code for the item to be used into the frontend page
	 * @param string the item object from simple_html_dom
	 * 
	 * Return String the html code
	 */
	public function onPagebuilderckRenderItemIcon($item) {
		return $item->innertext;
	}
}