<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
?>
<div id="elementscontainer">
	<div class="menulink" tab="tab_iconstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_iconstyles">
		<?php echo $this->menustyles->createIcon('icon', '.editfocus .iconck i.fa', false, false, true) ?>
		<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_LINK') ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_LINK_URL'); ?>
			</span>
			<span class="ckoption-field">
				<input id="linkurl" name="linkurl" class="inputbox"  value="" type="text" style="width:120px;" />
				<span class="ckbuttonstyle" onclick="ckCallLinkManagerPopup('linkurl', 'all')">+</span>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_REL_TAG'); ?>
			</span>
			<span class="ckoption-field">
				<input id="linkrel" name="linkrel" class="inputbox"  value="" type="text" />
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_CSS_CLASS'); ?>
			</span>
			<span class="ckoption-field">
				<input id="linkcss" name="linkcss" class="inputbox"  value="" type="text"  />
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hand-point-090.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_ONCLICK'); ?>
			</span>
			<span class="ckoption-field">
				<input id="linkonlick" name="linkonlick" class="inputbox"  value="" type="text"  />
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link_add.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_TARGET'); ?>
			</span>
			<span class="ckoption-field">
				<select id="linktarget" class="inputbox" name="linktarget" >
					<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
					<option value="_blank"><?php echo \Joomla\CMS\Language\Text::_('CK_NEW_WINDOW'); ?></option>
				</select>
			</span>
			<div class="ckclr"></div>
		</div>
	</div>
	<div class="menulink" tab="tab_blocstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_STYLES'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_blocstyles">
		<?php echo $this->menustyles->createBackground('icon') ?>
		<?php echo $this->menustyles->createDimensions('icon', true, true) ?>
		<?php echo $this->menustyles->createDecoration('icon') ?>
		<?php echo $this->menustyles->createShadow('icon') ?>
	</div>
</div>

<script language="javascript" type="text/javascript">
var focus = $ck('.editfocus');
function ckLoadEditionPopup() {
	ckFillEditionPopup(focus.attr('id'));
	ckGetIconPosition('.editfocus .iconck i.fa', '#iconicon-position button');
	ckGetIconMargin('.editfocus .iconck i.fa', '#iconicon_margin');
	$ck('#iconicon-class').val(focus.find('.iconck > i').attr('data-iconclass'));
}

function ckBeforeSaveEditionPopup() {
	if (ckCheckIconType()) {
		ckUpdatePreviewArea();
	}
}

function ckCheckIconType() {
	var isSvg = focus.find('.iconck svg').length;
	var isFont = focus.find('.iconck > i').length;
	var type = $ck('#elementscontainer input[type="radio"][name="iconicontype"]:checked').val();
	if (isSvg && type == 'svg') return true;
	if (isFont && type == 'fa') return true;
	if (! isFont && ! isSvg) return true; // in case of ...
	alert('Please update the icon, it does not match the selected type');
	return false;
}

function ckUpdatePreviewArea() {
	var focusIcon = focus.find('.iconck');
	var html = focus.find('i,.pbckicon')[0].outerHTML;
	var linkurl = $ck('#linkurl').val();
	// add link
	if (linkurl) {
		var linkrel = $ck('#linkrel').val();
		var linkcss = $ck('#linkcss').val();
		var linkonlick = $ck('#linkonlick').val();
		var linktarget = $ck('#linktarget').val();
		html = '<a href="' + linkurl + '"'
				+ (linkrel ? ' rel="' + linkrel + '"' : '')
				+ (linkcss ? ' class="' + linkcss + '"' : '')
				+ (linkonlick ? ' onclick="' + linkonlick + '"' : '')
				+ (linktarget != 'default' ? ' target="' + linktarget + '"' : '')
				+ '>'
				+ html 
				+ '</a>';
	}
	focusIcon.html(html);
}

function ckSelectIcon(icon) {
	var focusIcon = $ck('.editfocus .iconck');
	focusIcon.empty().append(icon);
	return focusIcon;
}

ckInitIconPosition('.editfocus .iconck i.fa', '#iconicon-position button');
</script>