<?php
/**
 * @copyright	Copyright (C) 2015 Cédric KEIFLIN alias ced1870
 * https://www.template-creator.com
 * https://www.joomlack.fr
 * @license		GNU/GPL
 * */
 
defined('_JEXEC') or die('Restricted access');
jimport('joomla.event.plugin');

class plgPagebuilderckIcontext extends \Joomla\CMS\Plugin\CMSPlugin {

	private $context = 'PLG_PAGEBUILDERCK_ICONTEXT';

	private $type = 'icontext';

	function __construct(&$subject, $params) {

		parent::__construct($subject, $params);
	}

	/* 
	 * Construct the Menu Item to drag into the interface
	 *
	 * Return Object with item data
	 */
	public function onPagebuilderckAddItemToMenu() {
		// load the language files of the plugin
		$this->loadLanguage();
		// create the menu item
		$menuitem = new stdClass();
		$menuitem->type = $this->type;
		$menuitem->group = 'text';
		$menuitem->title = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_TITLE');
		$menuitem->description = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_DESC');
		$menuitem->image = \Joomla\CMS\Uri\Uri::root(true) . '/plugins/pagebuilderck/icontext/assets/images/icontext.svg';

		return $menuitem;
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemContentIcontext() {
		$input = \Joomla\CMS\Factory::getApplication()->input;
		$id = $input->get('ckid', '', 'string');
		// ckstyle and inner classes are needed to get the styles from the interface
		?>
		<div id="<?php echo $id; ?>" class="cktype" data-type="icontext" data-layout="top">
			<div class="tab_textedition ckprops" textalignementcenter="checked" fieldslist="textalignementleft,textalignementcenter,textalignementright,textalignementjustify"></div>
			<div class="tab_titleedition ckprops" titlefontsize="25" titlealignementcenter="checked" titlepaddings="10" fieldslist="titlefontsize,titlealignementleft,titlealignementcenter,titlealignementright,titlealignementjustify,titlepaddings"></div>
			<div class="tab_iconstyles ckprops" iconicontype="svg" iconiconsvgsize="40" iconiconsvgstrokewidth="1.6" iconalignementcenter="checked" fieldslist="iconicontype,iconiconsvgsize,iconiconsvgstrokewidth,iconalignementleft,iconalignementcenter,iconalignementright"></div>
			<div class="tab_blocstyles ckprops" fieldslist="blocbackgroundcolorstart,blocbackgroundpositionend,blocbackgrounddirection,blocbackgroundimageattachment,blocbackgroundimagerepeat,blocbackgroundimagesize,blocalignementleft,blocalignementcenter,blocalignementright,blocalignementjustify,blocpaddings,blocbordertopstyle,blocborderrightstyle,blocborderbottomstyle,blocborderleftstyle,blocbordersstyle,blocshadowinset" iconalignementcenter="checked" blocbackgroundcolorstart="" blocbackgroundpositionend="100" blocbackgrounddirection="topbottom" blocbackgroundimageattachment="scroll" blocbackgroundimagerepeat="no-repeat" blocbackgroundimagesize="auto" blocpaddings="" blocbordertopstyle="solid" blocborderrightstyle="solid" blocborderbottomstyle="solid" blocborderleftstyle="solid" blocbordersstyle="solid" blocshadowinset="0"></div>	<div class="ckstyle">
				<style>
				#<?php echo $id; ?> > div.inner {
				}

				#<?php echo $id; ?> .iconck {
					text-align: center;
				}

				#<?php echo $id; ?> .titleck {
					padding: 10px;
					text-align: center;
					font-size: 25px;
					text-align: center;
				}
				#<?php echo $id; ?> .contentck {
					text-align: center;
				}
				#<?php echo $id; ?> svg * {
					stroke-width: 1.6;
				}

				#<?php echo $id; ?> svg.svgicon-ionicon *, #<?php echo $id; ?> svg.svgicon-fontawesome * {
					stroke-width: 25.6;
				}

				#<?php echo $id; ?> svg {
					width: 40px;
					height: 40px;
				}
				</style>
			</div>
			<div class="inner">
				<div class="iconck">
					<span class="pbckicon" data-path="tabler_photo.svg" data-pos="undefined" style="display:inline-block;">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-photo" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round" style="display: inline-block;">
							<line x1="15" y1="8" x2="15.01" y2="8"></line>
							<rect x="4" y="4" width="16" height="16" rx="3"></rect>
							<path d="M4 15l4 -4a3 5 0 0 1 3 0l5 5"></path>
							<path d="M14 14l1 -1a3 5 0 0 1 3 0l2 2"></path>
						</svg>
					</span>
				</div>
				<div class="contentck">
					<div class="titleck">Title</div>
					<div class="textck">
						<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed molestie scelerisque ultrices. Nullam venenatis, felis ut accumsan vestibulum, diam leo congue nisl, eget luctus sapien libero eget urna. Duis ac pellentesque nisi.</p>
					</div>
				</div>
			</div>
		</div> 
		<?php
	}

	/* 
	 * Load the interface for the item edition
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemOptionsIcontext() {
		// load the language files of the plugin
		$this->loadLanguage();
		// load the interface for the options
		$tpl = JPATH_SITE . '/plugins/pagebuilderck/icontext/layouts/edit_icontext.php';
		return $tpl;
	}

	/* 
	 * Display the html code for the item to be used into the frontend page
	 * @param string the item object from simple_html_dom
	 * 
	 * Return String the html code
	 */
	public function onPagebuilderckRenderItemIcontext($item) {
		return $item->innertext;
	}
}