<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
?>
<div class="menustylescustom" data-prefix="image" data-rule=".imageck img"></div>
<div id="elementscontainer">
	<div class="menulink" tab="tab_image"><?php echo \Joomla\CMS\Language\Text::_('CK_EDITION'); ?></div>
		<div class="tab menustyles ckproperty" id="tab_image">
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_IMAGE') ?></div>
			<div class="ckoption">
				<input class="inputboxfake" type="text" value="" name="<?php echo $id; ?>imageurl" id="<?php echo $id; ?>imageurl" style="width:283px;margin:2px;" onchange="ckUpdateImagepreview()" />
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallLinkManagerPopup('<?php echo $id; ?>imageurl', 'image')"" ><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $id; ?>imageurl').val('').trigger('change');"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAR'); ?></a>
				<div class="clr"></div>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>width.png" width="15" height="15" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_WIDTH'); ?>
				</span>
				<span class="ckoption-field">
					<input class="inputbox" type="text" name="imagewidth" id="imagewidth" value="" style="" onchange="ckUpdateImagepreview()" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>height.png" width="15" height="15" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_HEIGHT'); ?>
				</span>
				<span class="ckoption-field">
					<input class="inputbox" type="text" name="imageheight" id="imageheight" value="" style="" onchange="ckUpdateImagepreview()" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_ALIGN'); ?>
				</span>
				<span class="ckoption-field ckbutton-group">
					<input id="imagealignementleft" class="inputbox" name="imagealignement" value="left" type="radio" onclick="ckSetActiveAlignmentButton()">
					<label class="ckbutton" for="imagealignementleft">
						<img src="<?php echo $this->imagespath; ?>text_align_left.png" width="16" height="16" />
					</label>
					<input id="imagealignementcenter" class="inputbox" name="imagealignement" value="center" type="radio" onclick="ckSetActiveAlignmentButton()">
					<label class="ckbutton" for="imagealignementcenter">
						<img src="<?php echo $this->imagespath; ?>text_align_center.png" width="16" height="16" />
					</label>
					<input id="imagealignementright" class="inputbox" name="imagealignement" value="right" type="radio" onclick="ckSetActiveAlignmentButton()">
					<label class="ckbutton" for="imagealignementright">
						<img src="<?php echo $this->imagespath; ?>text_align_right.png" width="16" height="16" />
					</label>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_CSS_CLASS'); ?>
				</span>
				<span class="ckoption-field">
					<input class="inputbox" type="text" name="imagecssclass" id="imagecssclass" value="" style="" onchange="ckUpdateImageAttribute('class', this.value)" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_ALT_TAG'); ?>
				</span>
				<span class="ckoption-field">
					<input class="inputbox" type="text" name="imagealt" id="imagealt" value="" style="" onchange="ckUpdateImageAttribute('alt', this.value)" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_TITLE'); ?>
				</span>
				<span class="ckoption-field">
					<input class="inputbox" type="text" name="imagetitle" id="imagetitle" value="" onchange="ckUpdateImageAttribute('title', this.value)" />
				</span>
			</div>

			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_IMAGE_EFFECT'); ?>
				</span>
				<span class="ckoption-field">
			<?php
			if (! \Joomla\CMS\Plugin\PluginHelper::isEnabled('system', 'imageeffectck') || ! \Joomla\CMS\Plugin\PluginHelper::isEnabled('editors-xtd', 'imageeffectckbutton')) { ?>
				<div class="alert alert-warning">
					<?php if (! \Joomla\CMS\Plugin\PluginHelper::isEnabled('system', 'imageeffectck')) { ?><b><?php echo \Joomla\CMS\Language\Text::_('CK_IMAGEEFFECTCK_NOT_INSTALLED') ?></b>
					<br /><a href="https://www.joomlack.fr/en/joomla-extensions/image-effect-ck" target="_blank"><?php echo \Joomla\CMS\Language\Text::_('CK_DOWNLOAD') ?> : Image Effect CK</a>
					<div class="clr"></div>
					<?php } ?>
					<?php if (! \Joomla\CMS\Plugin\PluginHelper::isEnabled('editors-xtd', 'imageeffectckbutton')) { ?><b><?php echo \Joomla\CMS\Language\Text::_('CK_IMAGEEFFECTCK_BUTTON_NOT_INSTALLED') ?></b>
					<br /><a href="https://www.joomlack.fr/en/joomla-extensions/image-effect-ck" target="_blank"><?php echo \Joomla\CMS\Language\Text::_('CK_DOWNLOAD') ?> : Image Effect CK Pro</a>
					<?php } ?>
				</div>
			<?php } else { ?>
				<script src="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/plugins/editors-xtd/imageeffectckbutton/assets/imageeffectckbutton.js"></script>
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="CKApi.Imageeffect.showInterface('ckValidateImageEffect()');" style="width:163px"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
			<?php } ?>
				</span>
			</div>
			<div class="ckclr"></div>

			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_LINK') ?></div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_LINK_URL'); ?></span>
				<span class="ckoption-field ckoption-field-with-button">
					<input class="inputbox link_attrib" type="text" name="linkurl" id="linkurl" value="" onchange="ckUpdateLinkAttribute('href', this.value)" />
					<span class="ckbuttonstyle" onclick="ckCallLinkManagerPopup('linkurl', 'all')">+</span>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_REL_TAG'); ?></span>
				<span class="ckoption-field">
					<input class="inputbox link_attrib" type="text" name="linkrel" id="linkrel" value="" onchange="ckUpdateLinkAttribute('rel', this.value)" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>text_signature.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_CSS_CLASS'); ?></span>
				<span class="ckoption-field">
					<input class="inputbox link_attrib" type="text" name="linkcss" id="linkcss" value="" onchange="ckUpdateLinkAttribute('class', this.value)" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hand-point-090.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_ONCLICK'); ?>
				</span>
				<span class="ckoption-field">
					<input id="linkonlick" name="linkonlick" class="inputbox"  value="" type="text" onchange="ckUpdateLinkAttribute('onclick', this.value)" />
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link_add.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_TARGET'); ?>
				</span>
				<span class="ckoption-field">
					<select id="linktarget" class="inputbox" name="linktarget" onchange="ckUpdateLinkAttribute('target', this.value)" >
						<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
						<option value="_blank"><?php echo \Joomla\CMS\Language\Text::_('CK_NEW_WINDOW'); ?></option>
					</select>
				</span>
				<div class="ckclr"></div>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>link_add.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_TITLE'); ?></span>
				<span class="ckoption-field">
					<input class="inputbox link_attrib" type="text" name="linktitle" id="linktitle" value="" onchange="ckUpdateLinkAttribute('title', this.value)" />
				</span>
			</div>

			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_LIGHTBOX') ?></div>
			<?php
			if (! \Joomla\CMS\Plugin\PluginHelper::isEnabled('system', 'mediabox_ck')) { ?>
				<div class="alert alert-danger"><b><?php echo \Joomla\CMS\Language\Text::_('CK_MEDIABOXCK_NOT_INSTALLED') ?></b><br /><a href="https://www.joomlack.fr/en/joomla-extensions/mediabox-ck" target="_blank"><?php echo \Joomla\CMS\Language\Text::_('CK_DOWNLOAD') ?> : Mediabox CK</a></div>
			<?php }
			?>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>magnifier.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_USE_LIGHTBOX'); ?></span>
				<span class="ckoption-field">
					<select class="inputbox" type="list" value="" name="uselightbox" id="uselightbox" onchange="ckToggleLightboxState(this.value)">
						<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
						<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
					</select>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>photo_album.png" width="16" height="16" />
					<?php echo \Joomla\CMS\Language\Text::_('CK_LIGHTBOX_ALBUM'); ?></span>
				<span class="ckoption-field">
					<select class="inputbox" type="list" value="" name="lightboxalbum" id="lightboxalbum" onchange="ckToggleLightboxAlbum(this.value)">
						<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
						<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
					</select>
				</span>
			</div>

		</div>
		<div class="menulink" tab="tab_blocstyles"><?php echo \Joomla\CMS\Language\Text::_('CK_STYLES'); ?></div>
		<div class="tab menustyles ckproperty" id="tab_blocstyles">
			<?php echo $this->menustyles->createImageStyles('image', 'image', '') ?>
		</div>
</div>
<div class="clr"></div>
<script language="javascript" type="text/javascript">
function ckLoadEditionPopup() {
	var focus = $ck('.editfocus');
	var focus_img = $ck('.editfocus img');
	$ck('#<?php echo $id; ?>imageurl').val(focus_img.attr('data-src'));
	ckFillEditionPopup(focus.attr('id'));
	ckUpdateLinkAttribute('href', $ck('#linkurl').val());
	ckUpdateLinkAttribute('rel', $ck('#linkrel').val());
	ckUpdateLinkAttribute('class', $ck('#linkcss').val());
	ckUpdateLinkAttribute('target', $ck('#linktarget').val());
}

function ckBeforeSaveEditionPopup() {
	var focus = $ck('.editfocus');
//	var focus_img = $ck('.editfocus img');
//	var image = $ck('#<?php echo $id; ?>_preview_image img');
	ckUpdateImagepreview();
//	ckSaveEditionPopup(focus.attr('id'));
//	ckCloseEditionPopup();
}

function ckUpdateImagepreview() {
	var focus_img = $ck('.editfocus img');
	var img_src = $ck('#<?php echo $id; ?>imageurl').val();
	// $ck('#<?php echo $id; ?>_preview_image img').attr('src', '<?php echo \Joomla\CMS\Uri\Uri::root(true); ?>/'+img_src)
	focus_img.attr('src', getImgPathFromImgSrc(img_src, true))
		.attr('width', $ck('#imagewidth').val())
		.attr('height', $ck('#imageheight').val())
		.attr('data-src', img_src);
	ckUpdateImageAttribute('class', $ck('#imagecssclass').val());
	ckUpdateImageAttribute('alt', $ck('#imagealt').val());
	ckUpdateImageAttribute('title', $ck('#imagetitle').val());
	ckAddDataOnImage($ck('.editfocus .imageck'));
}

// set active class for radio buttons
function ckSetActiveAlignmentButton() {
	$ck('#elementscontainer .inputbox[name="imagealignement"]').each(function() {
		if ($ck(this).prop('checked')) {
			$ck(this).next('label').addClass('active');
		} else {
			$ck(this).next('label').removeClass('active');
		}
	});
}

function ckUpdateImageAttribute(attribute, value) {
	var focus_img = $ck('.editfocus img');
	if (value) {
		focus_img.attr(attribute, value);
	} else {
		focus_img.removeAttr(attribute);
	}
	
}

function ckUpdateLinkAttribute(attribute, value) {
	var focus_img = $ck('.editfocus img');
	if (focus_img.parent()[0].tagName.toLowerCase() == 'a') {
		var imagelink = focus_img.parent();
		if (value && value != 'default') {
			imagelink.attr(attribute, value);
		} else {
			if (attribute == 'href') {
				$ck('.editfocus .imageck ').append(focus_img);
				$ck('.editfocus .imageck > a').remove();
			} else {
				imagelink.removeAttr(attribute);
			}
		}
	} else {
		if (value)
		focus_img.wrap('<a href="' + (attribute == 'href' ? value : '') + '"></a>');
		// if (attribute != 'href') {
			// alert('Warning : you must have an url to create a link');
		// }
	}
}

function ckToggleLightboxState(value) {
	// TODO : checker champ à changer avec $mediaboxParams->get
	if (value == 1) {
		// if link is empty, auto target the image
		if ($ck('#linkurl').val() == '') {
			$ck('#linkurl').val(getImgPathFromImgSrc($ck('#<?php echo $id; ?>imageurl').val(), true)).trigger('change');
		}
		if ($ck('#elementscontainer #linkrel').val().indexOf('lightbox') == -1) {
			var relvalue = $ck('#elementscontainer #linkrel').val() + ' lightbox';
			$ck('#elementscontainer #linkrel').val(relvalue.trim());
		}
		if ($ck('#lightboxalbum').val() == '1') {
			ckToggleLightboxAlbum(1);
		}
	} else {
		var relvalue = $ck('#elementscontainer #linkrel').val().replace('lightbox', '').trim();
		$ck('#elementscontainer #linkrel').val(relvalue);
		$ck('#lightboxalbum').val('0');
	}
	ckUpdateLinkAttribute('rel', $ck('#linkrel').val());
}

function ckToggleLightboxAlbum(value) {
	if ($ck('#uselightbox').val() != 1) {
		alert('Warning : you can not enable the album feature, the Lightbox option must be enabled');
		$ck('#lightboxalbum').val('0');
		return;
	}
	var pageid = $ck('input[name="id"]').val();
	if (value == 1) {
		if ($ck('#elementscontainer #linkrel').val().indexOf('lightbox[') != -1) { // check if lightbox already exists without album
			var re = /lightbox(\[.*?\])/g;
			var relvalue = $ck('#elementscontainer #linkrel').val();
			$ck('#elementscontainer #linkrel').val(relvalue.replace(re, 'lightbox[pagebuilderck' + pageid + ']'));
		} else {
			var relvalue = $ck('#elementscontainer #linkrel').val().replace('lightbox', '') + ' lightbox[pagebuilderck' + pageid + ']';
			$ck('#elementscontainer #linkrel').val(relvalue.trim());
		}
	} else {
		var re = /lightbox(\[.*?\])/g;
		var relvalue = $ck('#elementscontainer #linkrel').val().replace(re, 'lightbox').trim();
		$ck('#elementscontainer #linkrel').val(relvalue);
	}
	ckUpdateLinkAttribute('rel', $ck('#linkrel').val());
}

function ckValidateImageEffect() {
	var title = $ck('#imageeffectckbuttonimgdesc').val() ? $ck('#imageeffectckbuttonimgtitle').val() + '::' + $ck('#imageeffectckbuttonimgdesc').val() : $ck('#imageeffectckbuttonimgtitle').val();
	var imgCustomClasses = $ck('#imageeffectckbuttonimgclass').val() != '' ? ' ' + $ck('#imageeffectckbuttonimgclass').val() : '';
	var cssclass = $ck('#imageeffectckbuttoneffectslist').val() + imgCustomClasses;
	$ck('#imagetitle').val(title);
	$ck('#imagecssclass').val(cssclass).trigger('change');
}

/*
* Triggered from the Image Effect CK Params plugin, used to fill the data

 * @returns {undefined} */
function onImageeffectckmodalLoaded() {
	var focus_img = $ck('.editfocus img');
	var imgsrc = focus_img.attr('src');
	var imgtitletmp = $ck('#imagetitle').val();
	var imgclass = $ck('#imagecssclass').val();
	CKApi.Imageeffect.setFieldsValue(imgsrc, imgtitletmp, imgclass);
}

ckSetActiveAlignmentButton();
</script>
<style type="text/css">
#image_preview {
padding: 5px;
background: #f5f5f5;
border: 1px solid #ddd;
margin: 10px 10px 10px 0;
max-width: 600px;
/*height: 200px;*/
overflow: hidden;
}

#image_preview > img {
	max-width: 100%;
}
</style>