<?php
/**
 * @copyright	Copyright (C) 2015 Cédric KEIFLIN alias ced1870
 * https://www.template-creator.com
 * https://www.joomlack.fr
 * @license		GNU/GPL
 * */
 
defined('_JEXEC') or die('Restricted access');
jimport('joomla.event.plugin');

class plgPagebuilderckSeparator extends \Joomla\CMS\Plugin\CMSPlugin {

	private $context = 'PLG_PAGEBUILDERCK_SEPARATOR';

	private $type = 'separator';

	function __construct(&$subject, $params) {

		parent::__construct($subject, $params);
	}

	/* 
	 * Construct the Menu Item to drag into the interface
	 *
	 * Return Object with item data
	 */
	public function onPagebuilderckAddItemToMenu() {
		// load the language files of the plugin
		$this->loadLanguage();
		// create the menu item
		$menuitem = new stdClass();
		$menuitem->type = $this->type;
		$menuitem->group = 'text';
		$menuitem->title = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_TITLE');
		$menuitem->description = \Joomla\CMS\Language\Text::_($this->context . '_MENUITEM_DESC');
		$menuitem->image = \Joomla\CMS\Uri\Uri::root(true) . '/plugins/pagebuilderck/separator/assets/images/separator.svg';

		return $menuitem;
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemContentSeparator() {
		$input = \Joomla\CMS\Factory::getApplication()->input;
		$id = $input->get('ckid', '', 'string');
		// ckstyle and inner classes are needed to get the styles from the interface
		?>
		<div id="<?php echo $id; ?>" class="cktype" data-type="separator" >
			<div class="ckstyle">
			</div>
			<div class="separatorck">
				<span class="separatorck_before"></span>
				<span class="separatorck_text">Text Here</span>
				<span class="separatorck_after"></span>
			</div>
		</div>
		<?php
	}

	/* 
	 * Load the interface for the item edition
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemOptionsSeparator() {
		// load the language files of the plugin
		$this->loadLanguage();
		// load the interface for the options
		$tpl = JPATH_SITE . '/plugins/pagebuilderck/separator/layouts/edit_separator.php';
		return $tpl;
	}

	/* 
	 * Display the html code for the item to be used into the frontend page
	 * @param string the item object from simple_html_dom
	 * 
	 * Return String the html code
	 */
	public function onPagebuilderckRenderItemSeparator($item) {
		return $item->innertext;
	}
}