<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

class MenuStyles extends stdClass {

	public $imagespath;

	function __construct() {
		$this->imagespath = PAGEBUILDERCK_MEDIA_URI .'/images/menustyles/';
	}

	public function createBlocStyles($prefix = 'bloc', $objclass = '', $expert = false, $showlinks = true, $joomlaversion = 'j3', $showtext = true, $showdimensions = true, $showdecoration = true, $showshadow = true) {
		if (stristr($objclass, 'wrapper')) {
			$this->createBackground($prefix, true);
			if ($prefix == 'bloc')
				$this->createText($prefix);
			if ($prefix == 'bloc')
				$this->createDimensions($prefix, false, false, false, true);
			$this->createDecoration($prefix);
			$this->createShadow($prefix);
			$this->createCustom($prefix);
		} elseif (stristr($objclass, 'body')) {
			$this->createWrapperStyles($prefix, $joomlaversion);
			$this->createBackground($prefix, false, \Joomla\CMS\Language\Text::_('CK_PAGEBACKGROUND'));
			$this->createText($prefix);
			$this->createCustom($prefix);
		} else {
			$this->createBackground($prefix);
			if ($prefix != 'level1bg' && $prefix != 'level2bg' && $objclass != 'video' && $objclass != 'animnumber')
				if ($showtext) $this->createText($prefix, $showlinks);
			if ($prefix == 'level1bg' || $prefix == 'level2bg' || $expert == 'true' || (stristr($objclass, 'bannerlogo') && !stristr($objclass, 'mainbanner')) && (!stristr($objclass, 'column') && !stristr($objclass, 'flexiblemodule'))) {
				$useheight = true;
				$usewidth = true;
			} else {
				$useheight = false;
				$usewidth = false;
			}
			if ($showdimensions) $this->createDimensions($prefix, $useheight, $usewidth, $expert);
			if ($showdecoration) $this->createDecoration($prefix);
			if ($showshadow) $this->createShadow($prefix);
			$this->createCustom($prefix);
		}
	}

	public function createOverlayStyles($prefix = 'overlay', $usegradient = true) {
		$this->createBackground('overlay', $usegradient = true, $title = '', $expert = false, $useaccordion = false);
	}

	public function createTextStyles($prefix = 'bloc', $objclass = '', $fromicon = '', $removebutton = false, $showlinks = false) {
		if ($fromicon) $this->createIcon($prefix, $fromicon, $space = true, $align = true, $font = false, $useaccordion = false, $removebutton);
		$this->createText($prefix, $showlinks);
		$this->createDimensions($prefix);
		$this->createCustom($prefix);
	}

	public function createIconStyles($prefix = 'bloc', $objclass = '', $fromicon = '', $space = true, $align = true, $font = false, $removebutton = false, $iconhover = false, $fontalign = true) {
		$this->createIcon($prefix, $fromicon, $space, $align, $font, true, $removebutton, $fontalign, $selection = true, $iconhover);
		// $this->createIconText($prefix, false);
		$this->createBackground($prefix);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createImageStyles($prefix = 'bloc', $objclass = '', $fromicon = '') {
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createNormalStyles($prefix, $showlinks = true) {
		$this->createBackground($prefix);
		$this->createText($prefix, $showlinks);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createLogoStyles($prefix) {
		$this->createLogo($prefix);
		$this->createCustom($prefix);
	}

	public function createModuleStyles($prefix = 'module') {
		$this->createBackground($prefix);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createModuletitleStyles($prefix = 'moduletitle') {
		$this->createBackground($prefix);
		$this->createText($prefix, false);
		$this->createDimensions($prefix);
		$this->createDecoration($prefix);
		$this->createShadow($prefix);
		$this->createCustom($prefix);
	}

	public function createDivider($prefix = 'divider') {
		echo PagebuilderckHelper::showParamsMessage();
		$file = PAGEBUILDERCK_PATH . '/pro/includes/shapes.php';
		if (PagebuilderckHelper::getParams() == true && file_exists($file)) {
			include($file);
		}
	}

	function createVideobgStyles($prefix = 'bloc') {
		?>
		<div class="ckoption">
			<div class="menupaneblock">
				<div class="alert-message"><?php echo \Joomla\CMS\Language\Text::_('CK_VIDEO_URL_INFOS'); ?></div>
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_VIDEO_URL_MP4'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-field-large">
						<input class="inputbox inpubox-large" type="text" name="<?php echo $prefix; ?>videourlmp4" id="<?php echo $prefix; ?>videourlmp4" value="" style="width:200px;" />
					</div>
				</div>
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallMediaManagerPopup('<?php echo $prefix; ?>videourlmp4', 'video')"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT') ?></a>
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_VIDEO_URL_WEBM'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-field-large">
						<input class="inputbox inpubox-large" type="text" name="<?php echo $prefix; ?>videourlwebm" id="<?php echo $prefix; ?>videourlwebm" value="" />
					</div>
				</div>
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallMediaManagerPopup('<?php echo $prefix; ?>videourlwebm', 'video')"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT') ?></a>
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_VIDEO_URL_OGV'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-field-large">
						<input class="inputbox inpubox-large" type="text" name="<?php echo $prefix; ?>videourlogv" id="<?php echo $prefix; ?>videourlogv" value="" />
					</div>
				</div>
				<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallMediaManagerPopup('<?php echo $prefix; ?>videourlogv', 'video')"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT') ?></a>
			</div>
			<div class="clr"></div>
		</div>
		<div class="clr"></div>
		<?php
	}

	public function createAnimations($prefix) {
	?>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_DURATION'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animdur" id="<?php echo $prefix; ?>animdur" value="1" onchange="" />
				<span class="ckoption-suffix">s</span>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_DELAY'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animdelay" id="<?php echo $prefix; ?>animdelay" value="0" onchange="" />
				<span class="ckoption-suffix">s</span>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shading.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_FADE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animfadeyes" class="inputbox" name="<?php echo $prefix; ?>animfade" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animfadeyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animfadeno" class="inputbox" name="<?php echo $prefix; ?>animfade" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animfadeno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_square_go.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_MOVE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animmoveyes" class="inputbox" name="<?php echo $prefix; ?>animmove" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animmoveyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animmoveno" class="inputbox" name="<?php echo $prefix; ?>animmove" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animmoveno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_DIRECTION'); ?>
			</span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>animmovedir" id="<?php echo $prefix; ?>animmovedir" value="" onchange="" >
					<option value="ltrck"><?php echo \Joomla\CMS\Language\Text::_('CK_LEFT_TO_RIGHT'); ?></option>
					<option value="rtlck"><?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT_TO_LEFT'); ?></option>
					<option value="ttbck"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP_TO_BOTTOM'); ?></option>
					<option value="bttck"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM_TO_TOP'); ?></option>
				</select>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_DISTANCE'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox" type="text" name="<?php echo $prefix; ?>animmovedist" id="<?php echo $prefix; ?>animmovedist" value="40" onchange="" />
				<span class="ckoption-suffix">px</span>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_rotate_clockwise.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_ROTATE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animrotyes" class="inputbox" name="<?php echo $prefix; ?>animrot" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animrotyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animrotno" class="inputbox" name="<?php echo $prefix; ?>animrot" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animrotno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_(''); ?></span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>animrotrad" id="<?php echo $prefix; ?>animrotrad" value="" onchange="" >
					<option value="45">45°</option>
					<option value="90">90°</option>
					<option value="180">180°</option>
					<option value="270">270°</option>
					<option value="360">360°</option>
				</select>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_handles.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_SCALE'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animscaleyes" class="inputbox" name="<?php echo $prefix; ?>animscale" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animscaleyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animscaleno" class="inputbox" name="<?php echo $prefix; ?>animscale" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animscaleno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>shape_flip_horizontal.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_FLIP'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animflipyes" class="inputbox" name="<?php echo $prefix; ?>animflip" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animflipyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animflipno" class="inputbox" name="<?php echo $prefix; ?>animflip" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animflipno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_(''); ?></span>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="<?php echo $prefix; ?>animflipdir" id="<?php echo $prefix; ?>animflipdir" value="" onchange="" >
					<option value="left"><?php echo \Joomla\CMS\Language\Text::_('CK_LEFT'); ?></option>
					<option value="right"><?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT'); ?></option>
					<option value="top"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?></option>
					<option value="bottom"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?></option>
				</select>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label menupanetitle">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>control_repeat.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_REPLAY_ANIMATION'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>animreplayyes" class="inputbox" name="<?php echo $prefix; ?>animreplay" value="1" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>animreplayyes">
				<?php echo \Joomla\CMS\Language\Text::_('JYES'); ?>
				</label>
				<input id="<?php echo $prefix; ?>animreplayno" class="inputbox" name="<?php echo $prefix; ?>animreplay" value="0" type="radio" checked>
				<label class="ckbutton" for="<?php echo $prefix; ?>animreplayno">
				<?php echo \Joomla\CMS\Language\Text::_('JNO'); ?>
				</label>
			</span>
			<div class="clr"></div>
		</div>
		<div style="text-align:center;">
			<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckPlayAnimationPreview()">
				<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-play-filled" width="16" height="16" viewBox="0 0 24 24" stroke-width="1.5" stroke="#fff" fill="none" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: sub;">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M6 4v16a1 1 0 0 0 1.524 .852l13 -8a1 1 0 0 0 0 -1.704l-13 -8a1 1 0 0 0 -1.524 .852z" stroke-width="0" fill="currentColor" />
</svg> <?php echo \Joomla\CMS\Language\Text::_('CK_PLAY_ANIMATION'); ?></a></div>
			<div class="clr">
		</div>
	<?php
	}

	/*public function createIconSelection($prefix, $fromicon, $removebutton = false) {
		?>
		<div style="resize:vertical;">
			<a href="javascript:void(0)" onclick="CKBox.open({id: 'pagebuilderckiconselect', handler: 'iframe', url: '<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/index.php?option=com_pagebuilderck&view=icons'});" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
			<?php if ($removebutton) { ?>
			<a href="javascript:void(0)" onclick="$ck('<?php echo $fromicon ?>').remove(); $ck('<?php echo $prefix; ?>icon-class').val('')" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN'); ?></a>  
			<?php } ?>
			<input type="text" id="<?php echo $prefix; ?>icon-class" name="<?php echo $prefix; ?>icon-class" placeholder="Ex : fa fa-eye" onchange="ckSelectFaIcon(this.value)" />
		</div>
		<?php
	}*/

	public function createIconOptions($prefix, $fromicon, $space = true, $align = true, $removebutton = false, $selection = true) {
	?>
		<input type="hidden" class="inputbox" name="<?php echo $prefix; ?>icontype" id="<?php echo $prefix; ?>icontype" />
		<?php if ($selection) { ?>
		<div>
			<a href="javascript:void(0)" onclick="CKBox.open({id: 'pagebuilderckiconselect', handler: 'iframe', url: '<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/index.php?option=com_pagebuilderck&view=icons'});" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
			<?php if ($removebutton) { ?>
			<a href="javascript:void(0)" onclick="$ck('<?php echo $fromicon ?>').remove(); $ck('<?php echo $prefix; ?>icon-class').val('')" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN'); ?></a>  
			<?php } ?>
			<input type="text" id="<?php echo $prefix; ?>icon-class" name="<?php echo $prefix; ?>icon-class" placeholder="Ex : fa fa-eye" onchange="ckSelectFaIcon(this.value)" />
		</div>
		<?php } ?>
		<fieldset id="fontawesomefieldset">
			<legend><?php echo \Joomla\CMS\Language\Text::_('CK_FONTAWESOME'); ?></legend>
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE'); ?></div>
			<div id="<?php echo $prefix; ?>icon-size" class="ckbutton-group small">
				<button data-width="default" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></button>
				<button data-width="fa-lg" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X1-3'); ?></button>
				<button data-width="fa-2x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X2'); ?></button>
				<button data-width="fa-3x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X3'); ?></button>
				<button data-width="fa-4x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X4'); ?></button>
				<button data-width="fa-5x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X5'); ?></button>
			</div>
			<?php if ($align) { ?>
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_POSITION'); ?></div>
			<div id="<?php echo $prefix; ?>icon-position" class="ckbutton-group">
				<button data-position="default" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></button>
				<button data-position="top" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?></button>
				<button data-position="middle" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_MIDDLE'); ?></button>
				<button data-position="bottom" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?></button>
			</div>
			<?php } ?>
			<?php if ($space) { ?>
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_MARGIN'); ?></div>
			<input type="text" id="<?php echo $prefix; ?>icon_margin" name="<?php echo $prefix; ?>icon_margin" placeholder="Ex : 10px" onchange="ckSetIconMargin('<?php echo $fromicon ?>', '#<?php echo $prefix; ?>icon_margin')" />
			<?php
			}
			?>
		</fieldset>
		<?php
	}

	public function createIcon($prefix, $fromicon, $space = true, $align = true, $font = false, $useaccordion = false, $removebutton = false, $fontalign = true, $selection = true, $iconhover = false, $iconsize = true, $selector = '') {
		?>
		<div style="padding: 2px 5px;text-align:center;">
			<span class="ckbutton-group">
				<input id="<?php echo $prefix; ?>icontypesvg" class="" name="<?php echo $prefix; ?>icontype" value="svg" type="radio" data-prefix="<?php echo $prefix; ?>">
				<label class="ckbutton" for="<?php echo $prefix; ?>icontypesvg">
					<?php echo \Joomla\CMS\Language\Text::_('CK_SVG_ICON') ?>
				</label>
				<input id="<?php echo $prefix; ?>icontypefa" class="" name="<?php echo $prefix; ?>icontype" value="fa" type="radio" data-prefix="<?php echo $prefix; ?>">
				<label class="ckbutton" for="<?php echo $prefix; ?>icontypefa">
					<?php echo \Joomla\CMS\Language\Text::_('CK_FONT_ICON') ?>
				</label>
			</span>
		</div>
		<input type="hidden" class="inputbox" name="<?php echo $prefix; ?>icontype" id="<?php echo $prefix; ?>icontype" />
		<?php if ($useaccordion) { ?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON') ?></div>
			<div class="menustylesblockaccordion">
		<?php } ?>
		<fieldset id="fontawesomefieldset">
			<legend><?php echo \Joomla\CMS\Language\Text::_('CK_FONT_ICON'); ?></legend>
			<div class="ckoption">
				<input type="text" class="inputboxfake inputbox-large" id="<?php echo $prefix; ?>icon-class" name="<?php echo $prefix; ?>icon-class" placeholder="Ex : fa fa-eye" onchange="ckSelectFaIcon(this.value)" />
			</div>
			<?php /*if ($iconsize) { ?>
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE'); ?></div>
			<div id="<?php echo $prefix; ?>icon-size" class="ckbutton-group small">
				<button data-width="default" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></button>
				<button data-width="fa-lg" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X1-3'); ?></button>
				<button data-width="fa-2x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X2'); ?></button>
				<button data-width="fa-3x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X3'); ?></button>
				<button data-width="fa-4x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X4'); ?></button>
				<button data-width="fa-5x" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_SIZE_X5'); ?></button>
			</div>
			<?php }*/ ?>
			<?php if ($space) { ?>
			<div class="ckoption">
				<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_ICON_MARGIN'); ?></span>
				<span class="ckoption-field">
					<input type="text"  class="inputboxfake" id="<?php echo $prefix; ?>icon_margin" name="<?php echo $prefix; ?>icon_margin" placeholder="Ex : 10px" onchange="ckSetIconMargin('<?php echo $fromicon ?>', '#<?php echo $prefix; ?>icon_margin')" />
				</span>
			</div>
			<?php } ?>
			<?php if ($font) { ?>
			<div id="fontawesomefieldsetoptions">
				<div class="ckoption">
					<span class="ckoption-label">
						<?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
						<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
					</span>
					<span class="ckoption-field">
						<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" />
					</span>
				</div>
				<div class="ckoption">
					<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_SIZE'); ?></span>
					<span class="ckoption-field">
						<input type="text" class="inputbox" id="<?php echo $prefix; ?>fontsize" name="<?php echo $prefix; ?>fontsize" placeholder="24"  onchange="//ckSetFontIconSize()" >
	
					</span>
				</div>
			</div>
			<?php } ?>
		</fieldset>

		<div style="clear:both;"></div>

		<fieldset id="iconsvgfieldset">
			<legend><?php echo \Joomla\CMS\Language\Text::_('CK_SVG_ICON'); ?></legend>
			<?php if ($selection) { ?>
			<div class="ckoption">
				<a href="javascript:void(0)" onclick="CKBox.open({id: 'pagebuilderckiconselect', handler: 'iframe', url: '<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/index.php?option=com_pagebuilderck&view=icons'});" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
				<?php if ($removebutton) { ?>
				<a href="javascript:void(0)" onclick="$ck('<?php echo $fromicon ?>').remove(); $ck('<?php echo $prefix; ?>icon-class').val('')" class="ckbuttonstyle"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN'); ?></a>  
				<?php } ?>
			</div>
			<?php } ?>
			<div class="ckoption">
				<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_SIZE'); ?></span>
				<span class="ckoption-field">
					<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgsize" name="<?php echo $prefix; ?>iconsvgsize" min="8" max="200" value="24" step="4" onchange="ckSetSvgIconSize()" style="width:115px;" >
					<input type="text" onchange="ckUpdateRangeInputs(this)">
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_STROKE'); ?></span>
				<span class="ckoption-field">
					<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgstrokewidth" name="<?php echo $prefix; ?>iconsvgstrokewidth" min="0" max="3" value="2" step="0.2" onchange="ckSetSvgIconStroke()" style="width:115px;">
					<input type="text" onchange="ckUpdateRangeInputs(this)">
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_STROKE'); ?> <?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
				</span>
				<span class="ckoption-field">
					<input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>iconsvgstroke" id="<?php echo $prefix; ?>iconsvgstroke" onblur="ckSetSvgIconStrokeColor()" />
					<?php if ($iconhover) { ?><input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>hovericonsvgstroke" id="<?php echo $prefix; ?>hovericonsvgstroke" onblur="ckSetSvgIconStrokeColor()" /><?php } ?>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_FILL'); ?> <?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
				</span>
				<span class="ckoption-field">
					<input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>iconsvgfill" id="<?php echo $prefix; ?>iconsvgfill" onblur="ckSetSvgIconFillColor()" />
					<?php if ($iconhover) { ?><input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>hovericonsvgfill" id="<?php echo $prefix; ?>hovericonsvgfill" onblur="ckSetSvgIconFillColor()" /><?php } ?>
				</span>
			</div>
		</fieldset>
		<?php if ($align) { ?>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_ICON_POSITION'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<select id="<?php echo $prefix; ?>icon-position" name="<?php echo $prefix; ?>icon-position" class="inputbox">
					<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
					<option value="top"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?></option>
					<option value="middle"><?php echo \Joomla\CMS\Language\Text::_('CK_MIDDLE'); ?></option>
					<option value="bottom"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?></option>
				</select>
			</span>
		</div>
		<?php } ?>
		<?php if ($fontalign) { ?>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_ALIGN'); ?>
			</span>
			<span class="ckoption-field ckbutton-group">
				<input id="<?php echo $prefix; ?>alignementleft" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="left" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>alignementleft">
					<img src="<?php echo $this->imagespath; ?>text_align_left.png" width="16" height="16" />
				</label>
				<input id="<?php echo $prefix; ?>alignementcenter" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="center" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>alignementcenter">
					<img src="<?php echo $this->imagespath; ?>text_align_center.png" width="16" height="16" />
				</label>
				<input id="<?php echo $prefix; ?>alignementright" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="right" type="radio">
				<label class="ckbutton" for="<?php echo $prefix; ?>alignementright">
					<img src="<?php echo $this->imagespath; ?>text_align_right.png" width="16" height="16" />
				</label>
			</span>
		</div>
		<?php } ?>
		<div style="clear:both;"></div>
				<?php if ($useaccordion) { ?>
			</div>
		</div>
		<?php } ?>
		<?php
	}

	public function createIconSvgLight($prefix, $iconhover = false) {
		?>
		<input type="hidden" class="inputbox" name="<?php echo $prefix; ?>icontype" id="<?php echo $prefix; ?>icontype" />
		<fieldset>
			<legend><?php echo \Joomla\CMS\Language\Text::_('CK_SVG_ICON'); ?></legend>
			
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_FILL'); ?> <?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
				</span>
				<span class="ckoption-field">
					<input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>iconsvgfill" id="<?php echo $prefix; ?>iconsvgfill" onblur="ckSetSvgIconFillColor()" />
					<?php if ($iconhover) { ?><input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>hovericonsvgfill" id="<?php echo $prefix; ?>hovericonsvgfill" onblur="ckSetSvgIconFillColor()" /><?php } ?>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_SIZE'); ?></span>
				<span class="ckoption-field">
					<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgsize" name="<?php echo $prefix; ?>iconsvgsize" min="8" max="200" value="24" step="4" onchange="ckSetSvgIconSize()" style="width:115px;" >
					<input type="text" onchange="ckUpdateRangeInputs(this)">
				</span>
			</div>
		
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_STROKE'); ?> <?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
				</span>
				<span class="ckoption-field">
					<input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>iconsvgstroke" id="<?php echo $prefix; ?>iconsvgstroke" onblur="ckSetSvgIconStrokeColor()" />
					<?php if ($iconhover) { ?><input class="inputbox colorPicker cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>" type="text" value="" name="<?php echo $prefix; ?>hovericonsvgstroke" id="<?php echo $prefix; ?>hovericonsvgstroke" onblur="ckSetSvgIconStrokeColor()" /><?php } ?>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label"><?php echo \Joomla\CMS\Language\Text::_('CK_STROKE'); ?></span>
				<span class="ckoption-field">
					<input type="range" class="inputbox cknoupdate ckrangeinputupdate" id="<?php echo $prefix; ?>iconsvgstrokewidth" name="<?php echo $prefix; ?>iconsvgstrokewidth" min="0" max="3" value="2" step="0.2" onchange="ckSetSvgIconStroke()" style="width:115px;">
					<input type="text" onchange="ckUpdateRangeInputs(this)">
			</div>
			<div style="clear:both;"></div>
		</fieldset>
		<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_VERTICAL_ALIGN'); ?></div>
		<div id="<?php echo $prefix; ?>icon-position" class="ckbutton-group">
			<button data-position="default" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></button>
			<button data-position="top" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?></button>
			<button data-position="middle" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_MIDDLE'); ?></button>
			<button data-position="bottom" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?></button>
		</div>
		<br />
		<?php
	}

	public function createIconLight($prefix) {
		?>
		<fieldset>
			<legend><?php echo \Joomla\CMS\Language\Text::_('CK_FONT_ICON'); ?></legend>
			<div style="float:left; width: 50%;">
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
				</span>
				<span class="ckoption-field">
					<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" style="width:65px;"/>
				</span>
			</div>
			</div>
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_SIZE'); ?>
				</span>
				<span class="ckoption-field">
					<input type="range" class="inputbox cknoupdate ckrangeinputupdate ckresponsivable" id="<?php echo $prefix; ?>fontsize" name="<?php echo $prefix; ?>fontsize" min="8" max="200" value="24" step="1" onchange="//ckSetFontIconSize()" style="width:115px;">
					<input type="text" onchange="ckUpdateRangeInputs(this)">
				</span>
			</div>
		</fieldset>
		<div style="clear:both;"></div>
		<?php
	}

	public function createCustom($prefix) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_CUSTOMCSS') ?></div>
			<div class="menustylesblockaccordion">
		        <div style="text-align:left;clear:both;">
					<textarea class="inputbox ckresponsivable" name="<?php echo $prefix; ?>custom" id="<?php echo $prefix; ?>custom" rows="7" cols="20" style="width:95%;height:110px;"></textarea>
		        </div>
			</div>
		</div>
		<?php
	}

	public function createWrapperStyles($prefix, $joomlaversion) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_WRAPPER_PARAMS') ?></div>
			<div class="menustylesblockaccordion">
				<div style="text-align:left;clear:both;">
					<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_WRAPPER_WIDTH'); ?></div>
					<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>width.png" width="15" height="15" align="top" /></div><div style="float:left;"><input class="inputbox ckresponsivable hasTip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_WRAPPER_WIDTH_TIPS'); ?>" type="text" name="<?php echo $prefix; ?>width" id="<?php echo $prefix; ?>width" size="2" value="" style="" /></div>
					<div class="clr"></div>
				</div>
				<div style="text-align:left;clear:both;">
					<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_WRAPPER_FLUID'); ?></div>
					<div style="float:left;text-align:right;margin:5px 5px 0 0;">
						<select class="inputbox" type="list" name="<?php echo $prefix; ?>wrapperfluid" id="<?php echo $prefix; ?>wrapperfluid" value="" style="width:105px;" onchange="" >
							<option value="fixed"><?php echo \Joomla\CMS\Language\Text::_('CK_FIXED'); ?></option>
							<option value="fluid"><?php echo \Joomla\CMS\Language\Text::_('CK_FLUID'); ?></option>
						</select>
					</div>
					<div class="clr"></div>
				</div>
				<?php if ($joomlaversion == 'j3') { ?>
					<div style="text-align:left;clear:both;">
						<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_LOAD_BOOTSTRAP'); ?></div>
						<div style="float:left;text-align:right;margin:5px 5px 0 0;">
							<select class="inputbox" type="list" name="<?php echo $prefix; ?>loadboostrap" id="<?php echo $prefix; ?>loadboostrap" value="" style="width:105px;" onchange="" >
								<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
								<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
							</select>
						</div>
						<div class="clr"></div>
					</div>
				<?php } else { ?>
					<input class="inputbox" type="hidden" name="<?php echo $prefix; ?>loadboostrap" id="<?php echo $prefix; ?>loadboostrap" value="0" />
				<?php } ?>
					<div style="text-align:left;clear:both;">
						<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_GOOGLEANALYTICS'); ?></div>
						<div style="float:left;text-align:right;margin:5px 5px 0 0;">
							<select class="inputbox" type="list" name="<?php echo $prefix; ?>loadgoogleanalytics" id="<?php echo $prefix; ?>loadgoogleanalytics" value="" style="width:105px;" onchange="" >
								<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
								<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
							</select>
						</div>
						<div class="clr"></div>
					</div>
				<div class="clr"></div>
			</div>
		</div>
		<?php
	}

	public function createLogo($prefix, $usegradient = true, $title = '') {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo ($title ? $title : \Joomla\CMS\Language\Text::_('CK_LOGO')) ?></div>
			<div class="menustylesblockaccordion">
		        <div class="menupaneblock" style="margin-left:10px;">
		            <div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_LOGO'); ?></div>
		            <div style="">
		                <div style="text-align:left;">
							<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallImageManagerPopup('<?php echo $prefix; ?>backgroundimageurl')" ><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
		                    <a class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>backgroundimageurl').val('');"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN'); ?></a>
		                    <div class="clr"></div>
		                    <input class="inputbox" type="text" value="" name="<?php echo $prefix; ?>backgroundimageurl" id="<?php echo $prefix; ?>backgroundimageurl" size="7" style="width:150px; clear:both;" />
		                </div>

		            </div>
		        </div>
		        <div class="menupaneblock" style="margin-left:10px;">
		            <div class="menupanetitle" style="text-align:left;padding-left:0px;margin-top:0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_DIMENSIONS'); ?></div>
		            <div style="text-align:left;">
		                <div><?php echo \Joomla\CMS\Language\Text::_('CK_HEIGHT'); ?></div>
		                <div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>height.png" width="15" height="15" align="top" /></div><div style="float:left;"><input class="inputbox" type="text" name="logoheight" id="logoheight" size="2" value="" style="" /></div><div style="float:left;text-align:left;margin-left:3px;"></div>
		            </div>
		            <div style="text-align:left;clear:both;">
		                <div><?php echo \Joomla\CMS\Language\Text::_('CK_WIDTH'); ?></div>
		                <div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>width.png" width="15" height="15" align="top" /></div><div style="float:left;"><input class="inputbox" type="text" name="logowidth" id="logowidth" size="2" value="" style="" /></div><div style="float:left;text-align:left;margin-left:3px;"></div>
		            </div>
		        </div>
		        <div class="menupaneblock">
		            <div class="menupanetitle" style="text-align:left;width:150px;padding-left:60px;"><?php echo \Joomla\CMS\Language\Text::_('CK_MARGINS'); ?></div>
		            <div class="menupaneblock">
		                <div><div style="width:45px;float:left;text-align:right;margin-right:10px;"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?></div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>margintop.svg" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>margintop" id="<?php echo $prefix; ?>margintop" size="1" value="" /></div>
		                <div><div style="width:45px;float:left;text-align:right;margin-right:10px;"><?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT'); ?></div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginright.svg" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginright" id="<?php echo $prefix; ?>marginright" size="1" value="" /></div>
		                <div><div style="width:45px;float:left;text-align:right;margin-right:10px;"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?></div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginbottom.svg" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginbottom" id="<?php echo $prefix; ?>marginbottom" size="1" value=""  /></div>
		                <div><div style="width:45px;float:left;text-align:right;margin-right:10px;"><?php echo \Joomla\CMS\Language\Text::_('CK_LEFT'); ?></div><div style="float:left;text-align:right;margin-right:5px;"><img src="<?php echo $this->imagespath; ?>marginleft.svg" width="23" height="23" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>marginleft" id="<?php echo $prefix; ?>marginleft" size="1" value="" /></div>
		            </div>
		            <div class="menupaneblock">
		                <div style="width:21px;float:left;text-align:right;margin:1px 0 0 0;"><img src="<?php echo $this->imagespath; ?>all_margins.png" width="21" height="98" /></div>
		                <div style="float:left;text-align:left;margin:38px 0 0 5px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>margins" id="<?php echo $prefix; ?>margins" size="1" value="" /><div style="width:25px;float:right;text-align:left;margin-left:3px;"></div></div>
		            </div>
		        </div>
		        <div class="menupaneblock">
		            <div class="menupanetitle" style="text-align:left;width:150px;padding-left:0px;"><?php echo \Joomla\CMS\Language\Text::_('CK_PADDINGS'); ?></div>
		            <div class="menupaneblock">
		                <div><div style="float:left;text-align:right;margin:5px 10px 0 0;"><img src="<?php echo $this->imagespath; ?>paddingtop.svg" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingtop" id="<?php echo $prefix; ?>paddingtop" size="1" value="" /></div>
		                <div><div style="float:left;text-align:right;margin:5px 10px 0 0;"><img src="<?php echo $this->imagespath; ?>paddingright.svg" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingright" id="<?php echo $prefix; ?>paddingright" size="1" value="" /></div>
		                <div><div style="float:left;text-align:right;margin:5px 10px 0 0;"><img src="<?php echo $this->imagespath; ?>paddingbottom.svg" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingbottom" id="<?php echo $prefix; ?>paddingbottom" size="1" value=""  /></div>
		                <div><div style="float:left;text-align:right;margin:5px 10px 0 0;"><img src="<?php echo $this->imagespath; ?>paddingleft.svg" width="15" height="15" align="top" /></div><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddingleft" id="<?php echo $prefix; ?>paddingleft" size="1" value="" /></div>
		            </div>
		            <div class="menupaneblock">
		                <div style="width:21px;float:left;text-align:right;margin:1px 0 0 0;"><img src="<?php echo $this->imagespath; ?>all_paddings.png" width="15" height="98" /></div>
		                <div style="float:left;text-align:left;margin:38px 0 0 5px;"><input class="inputbox" type="text" name="<?php echo $prefix; ?>paddings" id="<?php echo $prefix; ?>paddings" size="1" value="" /><div style="width:20px;float:right;text-align:left;margin-left:3px;"></div></div>
		            </div>
		        </div>
				<div class="clr"></div>
		    </div>
		</div>
		<?php
	}

	public function createBackgroundColor($prefix) {
		?>
		<div style="clear:both">
			<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUND'); ?></div>
			<div class="ckoption">
				<span class="ckoption-label">
					<?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/>
				</span>
				<span class="ckoption-field">
					<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstart" id="<?php echo $prefix; ?>backgroundcolorstart" style="width: 155px;"/>
				</span>
			</div>
			<div class="ckoption">
				<span class="ckoption-label" style="width:90px;">
					<?php echo \Joomla\CMS\Language\Text::_('CK_OPACITY'); ?>
				</span>
				<span class="ckoption-field" style="width:190px;">
					<input class="inputbox ckresponsivable isGradientfield ckrangeinputupdate" type="range"  min="0" max="100" value="100" name="<?php echo $prefix; ?>backgroundopacity" id="<?php echo $prefix; ?>backgroundopacity" style="width:135px;"/>
					<input type="text" onchange="ckUpdateRangeInputs(this)" />
				</span>
			</div>
		</div>
		<?php
	}

	public function createBackground($prefix, $usegradient = true, $title = '', $expert = false, $useaccordion = true) {
		?>
		<?php if ($useaccordion) { ?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle<?php if ($expert == 'true') echo ' expert'; ?>"><?php echo ($title ? $title : \Joomla\CMS\Language\Text::_('CK_BACKGROUND')) ?></div>
			<div class="menustylesblockaccordion">
		<?php } ?>
				<?php
				if ($usegradient) {
					//$this->ckCreateGradientPreview($prefix);
					?><div class="menupaneblock" style="margin:0;width:80px;overflow:hidden;">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUNDGRADIENT'); ?></div>
						<div id="<?php echo $prefix; ?>gradientpreview" style="width:55px;height:130px;margin-top:3px;border:1px solid #808080;"><div class="injectstyles"></div></div>
					</div>
					<div class="menupaneblock" style="width: 200px;overflow:hidden;white-space: nowrap;">
						<div class="menupanetitle"><?php echo ($usegradient ? \Joomla\CMS\Language\Text::_('CK_BACKGROUNDCOLORS') : \Joomla\CMS\Language\Text::_('CK_BACKGROUNDCOLOR')) ?></div>

						<div class="menustyles-row">
							<div class="menustyles-text" style="color:#bcbcbc;width:56px;justify-content:center;"><?php echo \Joomla\CMS\Language\Text::_('0 %'); ?></div>
							<div class="menustyles-field"><input class="inputbox ckresponsivable colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstart" id="<?php echo $prefix; ?>backgroundcolorstart" size="6" style="width:63px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');" onchange="ckCreateGradientPreview('<?php echo $prefix ?>');"/></div>
							<div class="menustyles-icon"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('CK_MAINCOLOR'); ?></div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field"><input disabled="disabled" class="inputbox isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundpositionstop1" id="<?php echo $prefix; ?>backgroundpositionstop1" size="1" style="width:40px;text-align:center;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('%'); ?></div>
							<div class="menustyles-field"><input disabled="disabled" class="inputbox ckresponsivable colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstop1" id="<?php echo $prefix; ?>backgroundcolorstop1" size="6" style="width:63px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')"/></div>
							<div class="menustyles-icon"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('CK_STOP1COLOR'); ?></div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field"><input disabled="disabled" class="inputbox isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundpositionstop2" id="<?php echo $prefix; ?>backgroundpositionstop2" size="1" style="width:40px;text-align:center;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('%'); ?></div>
							<div class="menustyles-field"><input disabled="disabled" class="inputbox ckresponsivable colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstop2" id="<?php echo $prefix; ?>backgroundcolorstop2" size="6" style="width:63px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')" /></div>
							<div class="menustyles-icon"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('CK_STOP2COLOR'); ?></div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field"><input disabled="disabled" class="inputbox isGradientfield" type="text" value="100" name="<?php echo $prefix; ?>backgroundpositionend" id="<?php echo $prefix; ?>backgroundpositionend" size="1" style="width:40px;text-align:center;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>');"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('%'); ?></div>
							<div class="menustyles-field"><input disabled="disabled" class="inputbox ckresponsivable colorPicker isGradientfield" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorend" id="<?php echo $prefix; ?>backgroundcolorend" size="6" style="width:63px;" onblur="ckCreateGradientPreview('<?php echo $prefix ?>')"/></div>
							<div class="menustyles-icon"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('CK_ENDCOLOR'); ?></div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field">
								<select class="inputbox ckresponsivable" type="list" value="" name="<?php echo $prefix; ?>backgrounddirection" id="<?php echo $prefix; ?>backgrounddirection" style="width: 120px;">
									<option value="topbottom"><?php echo \Joomla\CMS\Language\Text::_('CK_TOPTOBOTTOM'); ?></option>
									<option value="bottomtop"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOMTOTOP'); ?></option>
									<option value="leftright"><?php echo \Joomla\CMS\Language\Text::_('CK_LEFTTORIGHT'); ?></option>
									<option value="rightleft"><?php echo \Joomla\CMS\Language\Text::_('CK_RIGHTTOLEFT'); ?></option>
								</select>
							</div>
							<div class="menustyles-text"><?php echo \Joomla\CMS\Language\Text::_('CK_DIRECTION'); ?></div>
						</div>
						
					</div>
					<div class="menustyles-row">
						<div class="menustyles-text" style="float:left;width:137px;"><?php echo \Joomla\CMS\Language\Text::_('CK_OPACITY'); ?></div>
						<div class="menustyles-field">
							
							<input class="inputbox ckresponsivable isGradientfield ckrangeinputupdate" type="range"  min="0" max="100" value="100" name="<?php echo $prefix; ?>backgroundopacity" id="<?php echo $prefix; ?>backgroundopacity" style="width:165px;"/>
							<input type="text" onchange="ckUpdateRangeInputs(this)" />
						</div>
					</div>
		<?php } else { ?>
					<div class="menupaneblock" style="margin:0 15px 0 0;">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUNDCOLOR'); ?></div>
						<div style="float:left;"><input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>backgroundcolorstart" id="<?php echo $prefix; ?>backgroundcolorstart" size="6" style="width:52px;" /></div><div style="float:left;margin:4px 2px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div><?php echo \Joomla\CMS\Language\Text::_('CK_MAINCOLOR'); ?>
						<input class="inputbox ckresponsivable" type="text" value="" name="<?php echo $prefix; ?>backgroundopacity" id="<?php echo $prefix; ?>backgroundopacity" size="1" style="width:22px;"/><?php echo \Joomla\CMS\Language\Text::_('CK_OPACITY'); ?>
					</div>
					<?php }
				?>
				<div>
					<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUNDIMAGE'); ?></div>
					<div class="menustyles-row">
						<div class="menustyles-field menustyles-field-large">
							<input class="inputbox ckresponsivable" type="text" value="" name="<?php echo $prefix; ?>backgroundimageurl" id="<?php echo $prefix; ?>backgroundimageurl" />
						</div>
					</div>
					<div class="menustyles-row">
						<div class="menustyles-field" style="width: 60%">
							<a class="ckbuttonstyle" href="javascript:void(0)" onclick="ckCallImageManagerPopup('<?php echo $prefix; ?>backgroundimageurl')" ><?php echo \Joomla\CMS\Language\Text::_('CK_SELECT'); ?></a>
						</div>
						<div class="menustyles-field" style="width: 40%">
							<a class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>backgroundimageurl').val('');"><?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN'); ?></a>
						</div>
					</div>
					<div class="menustyles-row">
						<div class="menustyles-text" style="width: 10%;justify-content: center;">
							<?php echo \Joomla\CMS\Language\Text::_('x'); ?>
						</div>
						<div class="menustyles-field" style="width: 40%">
							<input class="inputbox ckresponsivable" type="text" value="" name="<?php echo $prefix; ?>backgroundimageleft" id="<?php echo $prefix; ?>backgroundimageleft" placeholder="center" />
						</div>
						<div class="menustyles-text" style="width: 10%;justify-content: center;">
							<?php echo \Joomla\CMS\Language\Text::_('y'); ?>
						</div>
						<div class="menustyles-field" style="width: 40%">
							<input class="inputbox ckresponsivable" type="text" value="" name="<?php echo $prefix; ?>backgroundimagetop" id="<?php echo $prefix; ?>backgroundimagetop" placeholder="center" />
						</div>
					</div>
					<div class="menustyles-row">
						<div class="menustyles-text menustyles-text-label">
							<?php echo \Joomla\CMS\Language\Text::_('CK_ATTACHMENT'); ?>
						</div>
						<div class="menustyles-field menustyles-field-large">
							<select class="inputbox ckresponsivable" type="list" value="" name="<?php echo $prefix; ?>backgroundimageattachment" id="<?php echo $prefix; ?>backgroundimageattachment" >
								<option value="scroll"><?php echo \Joomla\CMS\Language\Text::_('scroll'); ?></option>
								<option value="fixed"><?php echo \Joomla\CMS\Language\Text::_('fixed'); ?></option>
							</select>
						</div>
					</div>
					<div class="menustyles-row">
						<div class="menustyles-text menustyles-text-label">
							<?php echo \Joomla\CMS\Language\Text::_('CK_REPEAT'); ?>
						</div>
						<div class="menustyles-field menustyles-field-large">
							<select class="inputbox ckresponsivable" type="list" value="" name="<?php echo $prefix; ?>backgroundimagerepeat" id="<?php echo $prefix; ?>backgroundimagerepeat" >
								<option value="no-repeat"><?php echo \Joomla\CMS\Language\Text::_('JNONE'); ?></option>
								<option value="repeat-x"><?php echo \Joomla\CMS\Language\Text::_('CK_HORIZONTAL'); ?></option>
								<option value="repeat-y"><?php echo \Joomla\CMS\Language\Text::_('CK_VERTICAL'); ?></option>
								<option value="repeat"><?php echo \Joomla\CMS\Language\Text::_('CK_HORIZONTAL_VERTICAL'); ?></option>
							</select>
						</div>
					</div>
					<div class="menustyles-row">
						<div class="menustyles-text menustyles-text-label">
							<?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUND_SIZE'); ?>
						</div>
						<div class="menustyles-field menustyles-field-large">
							<select class="inputbox ckresponsivable" type="list" value="" name="<?php echo $prefix; ?>backgroundimagesize" id="<?php echo $prefix; ?>backgroundimagesize" >
								<option value="auto"><?php echo \Joomla\CMS\Language\Text::_('JNONE'); ?></option>
								<option value="cover"><?php echo \Joomla\CMS\Language\Text::_('CK_COVER'); ?></option>
							</select>
						</div>
					</div>
				</div>
				<div class="menupaneblock" style="margin-left:10px;">

				</div>
				<?php
				if ($prefix == 'rowbg') {
				?> 
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label"><?php echo \Joomla\CMS\Language\Text::_('CK_PARALLAX'); ?></div>
					<div class="menustyles-field">
					<select class="inputbox ckresponsivable" type="list" value="" name="<?php echo $prefix; ?>parallax" id="<?php echo $prefix; ?>parallax" style="width: 70px;">
						<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
						<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
					</select>
					</div>
					<div class="menustyles-field menustyles-field-large">
						<input class="inputbox ckresponsivable cktip" type="text" placeholder="50" value="" name="<?php echo $prefix; ?>parallaxspeed" id="<?php echo $prefix; ?>parallaxspeed" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SPEED'); ?>" style="text-align:center;"/>
					</div>
				</div>
				<?php
				}
				?>
				<div class="clr"></div>
		<?php if ($useaccordion) { ?>
			</div>
		</div>
		<?php } ?>
		<?php
	}

	public function createFont($prefix) {
		?>
		<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_POLICE'); ?></div>
		<div class="menustyles-row">
			<div class="menustyles-column" style="width:50%">
				<div class="menustyles-row">
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" />
					</div>
					<div class="menustyles-icon">
						<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/>
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-field">
						<input class="inputbox ckresponsivable" name="<?php echo $prefix; ?>fontsize" id="<?php echo $prefix; ?>fontsize" type="text" />
					</div>
					<div class="menustyles-icon">
						<svg width="100%" height="100%" viewBox="0 0 512 512" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linecap:round;stroke-linejoin:round;stroke-width:2.5px;">
							<g transform="matrix(2.08267,0,0,2.08267,-425.202,2.84748)">
								<g transform="matrix(5.58723,0,0,5.58723,204.162,-1.36723)">
									<rect x="0" y="0" width="44" height="44" style="fill:none;fill-rule:nonzero;"/>
								</g>
								<g transform="matrix(6.30496,0,0,6.30496,194.293,-21.8542)">
									<path d="M7.333,34.833L7.333,15.583C7.333,12.063 10.23,9.167 13.75,9.167C17.27,9.167 20.167,12.063 20.167,15.583L20.167,34.833" style="fill:none;fill-rule:nonzero;stroke:rgb(44,62,80);"/>
								</g>
								<g transform="matrix(6.30496,0,0,6.30496,194.293,-21.8542)">
									<path d="M7.333,23.833L20.167,23.833" style="fill:none;fill-rule:nonzero;stroke:rgb(44,62,80);"/>
								</g>
								<g transform="matrix(8.0764e-16,-13.1898,13.1898,8.0764e-16,-560.296,4825.8)">
									<g transform="matrix(0.480153,0,0,0.480153,346.287,56.2511)">
										<path d="M9.167,33L34.833,33" style="fill:none;fill-rule:nonzero;stroke:rgb(44,62,80);"/>
									</g>
									<g transform="matrix(0.480153,0,0,0.480153,346.287,56.2511)">
										<path d="M31.167,36.667L34.833,33L31.167,29.333" style="fill:none;fill-rule:nonzero;stroke:rgb(44,62,80);"/>
									</g>
									<g transform="matrix(0.480153,0,0,0.480153,346.287,56.2511)">
										<path d="M12.833,29.333L9.167,33L12.833,36.667" style="fill:none;fill-rule:nonzero;stroke:rgb(44,62,80);"/>
									</g>
								</g>
							</g>
						</svg>
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>fontweight" id="<?php echo $prefix; ?>fontweight" size="1" value="" />
					</div>
					<div class="menustyles-text">
						<?php echo \Joomla\CMS\Language\Text::_('CK_FONTWEIGHT'); ?>
					</div>
				</div>
			</div>
			<div class="menustyles-column" style="width:51%">
				<div class="menustyles-row">
					<span class="ckoption-field ckbutton-group">
						<input id="<?php echo $prefix; ?>alignementleft" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="left" type="radio">
						<label style="padding: 4px 9px;" class="ckbutton" for="<?php echo $prefix; ?>alignementleft">
							<img src="<?php echo $this->imagespath; ?>text_align_left.png" width="16" height="16" />
						</label>
						<input id="<?php echo $prefix; ?>alignementcenter" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="center" type="radio">
						<label style="padding: 4px 9px;" class="ckbutton" for="<?php echo $prefix; ?>alignementcenter">
							<img src="<?php echo $this->imagespath; ?>text_align_center.png" width="16" height="16" />
						</label>
						<input id="<?php echo $prefix; ?>alignementright" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="right" type="radio">
						<label style="padding: 4px 9px;" class="ckbutton" for="<?php echo $prefix; ?>alignementright">
							<img src="<?php echo $this->imagespath; ?>text_align_right.png" width="16" height="16" />
						</label>
						<input id="<?php echo $prefix; ?>alignementjustify" class="inputbox ckresponsivable" name="<?php echo $prefix; ?>alignement" value="justify" type="radio">
						<label style="padding: 4px 9px;" class="ckbutton" for="<?php echo $prefix; ?>alignementjustify">
							<img src="<?php echo $this->imagespath; ?>text_align_justify.png" width="16" height="16" />
						</label>
					</span>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-field menustyles-field-large" >
						<?php
							$googlefontsFromTemplate = PagebuilderckHelper::loadTemplateGooglefonts();
							$fonts = PagebuilderckHelper::getFonts();
							?>
							<select class="inputbox ckresponsivable" name="<?php echo $prefix; ?>fontfamily" id="<?php echo $prefix; ?>fontfamily" onchange="ckAddGooglefontFiles(this)">
								<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
								<option style="font-family:Times New Roman;" value="Times New Roman, Serif">Times New Roman</option>
								<option style="font-family:Helvetica;" value="Helvetica, sans-serif">Helvetica</option>
								<option style="font-family:Georgia;" value="Georgia, serif">Georgia</option>
								<option style="font-family:Courier New;" value="Courier New, serif">Courier New</option>
								<option style="font-family:Arial;" value="Arial, sans-serif">Arial</option>
								<option style="font-family:Verdana;" value="Verdana, sans-serif">Verdana</option>
								<option style="font-family:Comic Sans MS;" value="Comic Sans MS, cursive">Comic Sans MS</option>
								<option style="font-family:Tahoma;" value="Tahoma, sans-serif">Tahoma</option>
								<option style="font-family:Segoe UI;" value="Segoe UI, sans-serif">Segoe UI</option>
								<?php
								if (! empty($googlefontsFromTemplate)) {
									foreach ($googlefontsFromTemplate as $i => $gfont) {
										$gfont = str_replace('+', ' ',$gfont);
										?><option style="font-family:<?php echo $gfont ?>" value="<?php echo $gfont ?>"><?php echo $gfont ?></option><?php
									}
								}
								?>
										<?php
								if (! empty($fonts)) {
									foreach ($fonts as $i => $font) {
										$fontName = str_replace('+', ' ',$font->name);
										?><option style="font-family:<?php echo $fontName ?>" value="<?php echo $fontName ?>" data-font="google"><?php echo $fontName ?></option><?php
									}
								}
								?>
							</select>
					</div>
				</div>
				<input class="inputbox ckresponsivable isgooglefont" type="text" name="<?php echo $prefix; ?>googlefont" id="<?php echo $prefix; ?>googlefont" size="1" value="" style="width:100px;display:none;" onchange="ckSetGoogleFont('<?php echo $prefix; ?>', '', this.value, '')" />
				<div class="menustyles-row">
					<div class="menustyles-field" style="width:100%;">
						<a href="javascript:void(0)" onclick="ckCallGoogleFontPopup('<?php echo $prefix; ?>')" class="ckbuttonstyle" ><?php echo \Joomla\CMS\Language\Text::_('CK_FONT_MANAGER'); ?></a>
					</div>
				</div>
			</div>
		</div>
		<?php
	}

	public function createText($prefix, $showlinks = true) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_TEXT'); ?></div>
			<div class="menustylesblockaccordion">
				<?php $this->createFont($prefix); ?>

				<div class="menustyles-row">
					<div class="menustyles-column" style="width:40%">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_STYLE'); ?></div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>fontbold" id="<?php echo $prefix; ?>fontbold" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="bold"><?php echo \Joomla\CMS\Language\Text::_('CK_BOLD'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-bold" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5h6a3.5 3.5 0 0 1 0 7h-6z" />
									<path d="M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" default="default" name="<?php echo $prefix; ?>fontitalic" id="<?php echo $prefix; ?>fontitalic" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="italic"><?php echo \Joomla\CMS\Language\Text::_('CK_ITALIC'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-italic" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M11 5l6 0" />
									<path d="M7 19l6 0" />
									<path d="M14 5l-4 14" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>fontunderline" id="<?php echo $prefix; ?>fontunderline" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="underline"><?php echo \Joomla\CMS\Language\Text::_('CK_UNDERLINE'); ?></option>
									<option value="nodecoration"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-underline" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5v5a5 5 0 0 0 10 0v-5" />
									<path d="M5 19h14" />
								  </svg>
							</div>
						</div><div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>fontuppercase" id="<?php echo $prefix; ?>fontuppercase" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="uppercase"><?php echo \Joomla\CMS\Language\Text::_('CK_UPPERCASE'); ?></option>
									<option value="lowercase"><?php echo \Joomla\CMS\Language\Text::_('CK_LOWERCASE'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-letter-case" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M17.5 15.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0" />
									<path d="M3 19v-10.5a3.5 3.5 0 0 1 7 0v10.5" />
									<path d="M3 13h7" />
									<path d="M21 12v7" />
								  </svg>
							</div>
						</div>
						
						
					</div>
					<div class="menustyles-column" style="width:60%">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_SPACING'); ?></div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>wordspacing" id="<?php echo $prefix; ?>wordspacing" value=""/>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-letter-spacing" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M5 12v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5" />
									<path d="M13 4l3 8l3 -8" />
									<path d="M5 18h14" />
									<path d="M17 20l2 -2l-2 -2" />
									<path d="M7 16l-2 2l2 2" />
								  </svg>
								  <?php echo \Joomla\CMS\Language\Text::_('CK_WORD'); ?>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>letterspacing" id="<?php echo $prefix; ?>letterspacing" value="" />
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-letter-spacing" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M5 12v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5" />
									<path d="M13 4l3 8l3 -8" />
									<path d="M5 18h14" />
									<path d="M17 20l2 -2l-2 -2" />
									<path d="M7 16l-2 2l2 2" />
								  </svg>
								  <?php echo \Joomla\CMS\Language\Text::_('CK_LETTER'); ?>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>lineheight" id="<?php echo $prefix; ?>lineheight" value="" />
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-line-height" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M3 8l3 -3l3 3" />
									<path d="M3 16l3 3l3 -3" />
									<path d="M6 5l0 14" />
									<path d="M13 6l7 0" />
									<path d="M13 12l7 0" />
									<path d="M13 18l7 0" />
								  </svg>
								  <?php echo \Joomla\CMS\Language\Text::_('CK_LINEHEIGHT'); ?>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>textindent" id="<?php echo $prefix; ?>textindent" value="" />
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-indent-increase" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M20 6l-11 0" />
									<path d="M20 12l-7 0" />
									<path d="M20 18l-11 0" />
									<path d="M4 8l4 4l-4 4" />
								  </svg>
								  <?php echo \Joomla\CMS\Language\Text::_('CK_TEXTINDENT'); ?>
							</div>
						</div>
					</div>
				</div>

		<?php if ($showlinks) { ?>
				<div class="menustyles-row">
					<div class="menustyles-column" style="width:40%">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMALLINK'); ?></div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>normallinkfontbold" id="<?php echo $prefix; ?>normallinkfontbold" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="bold"><?php echo \Joomla\CMS\Language\Text::_('CK_BOLD'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-bold" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5h6a3.5 3.5 0 0 1 0 7h-6z" />
									<path d="M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" default="default" name="<?php echo $prefix; ?>normallinkfontitalic" id="<?php echo $prefix; ?>normallinkfontitalic" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="italic"><?php echo \Joomla\CMS\Language\Text::_('CK_ITALIC'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-italic" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M11 5l6 0" />
									<path d="M7 19l6 0" />
									<path d="M14 5l-4 14" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>normallinkfontunderline" id="<?php echo $prefix; ?>normallinkfontunderline" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="underline"><?php echo \Joomla\CMS\Language\Text::_('CK_UNDERLINE'); ?></option>
									<option value="nodecoration"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-underline" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5v5a5 5 0 0 0 10 0v-5" />
									<path d="M5 19h14" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>normallinkfontuppercase" id="<?php echo $prefix; ?>normallinkfontuppercase" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="uppercase"><?php echo \Joomla\CMS\Language\Text::_('CK_UPPERCASE'); ?></option>
									<option value="lowercase"><?php echo \Joomla\CMS\Language\Text::_('CK_LOWERCASE'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-letter-case" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M17.5 15.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0" />
									<path d="M3 19v-10.5a3.5 3.5 0 0 1 7 0v10.5" />
									<path d="M3 13h7" />
									<path d="M21 12v7" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>normallinkcolor" id="<?php echo $prefix; ?>normallinkcolor" />
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/>
							</div>
						</div>
					</div>
					<div class="menustyles-column" style="width:60%">
						<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_HOVERLINK'); ?></div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>hoverlinkfontbold" id="<?php echo $prefix; ?>hoverlinkfontbold" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="bold"><?php echo \Joomla\CMS\Language\Text::_('CK_BOLD'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-bold" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5h6a3.5 3.5 0 0 1 0 7h-6z" />
									<path d="M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" default="default" name="<?php echo $prefix; ?>hoverlinkfontitalic" id="<?php echo $prefix; ?>hoverlinkfontitalic" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="italic"><?php echo \Joomla\CMS\Language\Text::_('CK_ITALIC'); ?></option>
									<option value="normal"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-italic" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M11 5l6 0" />
									<path d="M7 19l6 0" />
									<path d="M14 5l-4 14" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>hoverlinkfontunderline" id="<?php echo $prefix; ?>hoverlinkfontunderline" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="underline"><?php echo \Joomla\CMS\Language\Text::_('CK_UNDERLINE'); ?></option>
									<option value="nodecoration"><?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-underline" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M7 5v5a5 5 0 0 0 10 0v-5" />
									<path d="M5 19h14" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<select class="inputbox ckresponsivable" value="default" name="<?php echo $prefix; ?>hoverlinkfontuppercase" id="<?php echo $prefix; ?>hoverlinkfontuppercase" >
									<option value="default"><?php echo \Joomla\CMS\Language\Text::_('CK_DEFAULT'); ?></option>
									<option value="uppercase"><?php echo \Joomla\CMS\Language\Text::_('CK_UPPERCASE'); ?></option>
									<option value="lowercase"><?php echo \Joomla\CMS\Language\Text::_('CK_LOWERCASE'); ?></option>
								</select>
							</div>
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-letter-case" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
									<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
									<path d="M17.5 15.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0" />
									<path d="M3 19v-10.5a3.5 3.5 0 0 1 7 0v10.5" />
									<path d="M3 13h7" />
									<path d="M21 12v7" />
								  </svg>
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>hoverlinkcolor" id="<?php echo $prefix; ?>hoverlinkcolor" />
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/>
							</div>
						</div>
					</div>
				</div>
		<?php } ?>
				
				<div class="clr"></div>
			</div>
		</div>
		<?php
	}

	public function createDimensions($prefix, $useheight = false, $usewidth = false, $expert = false, $iswrapper = false) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_MISE_FORME'); ?></div>
			<div class="menustylesblockaccordion">
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_MARGINS'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-column" style="width:60%;">
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>margintop.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>margintop" id="<?php echo $prefix; ?>margintop" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>marginright.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>marginright" id="<?php echo $prefix; ?>marginright" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>marginbottom.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>marginbottom" id="<?php echo $prefix; ?>marginbottom" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_LEFT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>marginleft.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>marginleft" id="<?php echo $prefix; ?>marginleft" value="" />
							</div>
						</div>
					</div>
					<div class="menustyles-column" style="justify-content: center;position:relative;display:flex;margin-left:10px;">
						<div style="width:10px;height:40px;border-top:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;top:3px;"></div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>margins.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>margins" id="<?php echo $prefix; ?>margins" size="1" value="" />
							</div>
						</div>
						<div style="width:10px;height:40px;border-bottom:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;bottom:3px;"></div>
					</div>
				</div>
				<p>&nbsp;</p>
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_PADDINGS'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-column" style="width:60%;">
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_TOP'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>paddingtop.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>paddingtop" id="<?php echo $prefix; ?>paddingtop" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>paddingright.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>paddingright" id="<?php echo $prefix; ?>paddingright" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>paddingbottom.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>paddingbottom" id="<?php echo $prefix; ?>paddingbottom" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_LEFT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>paddingleft.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>paddingleft" id="<?php echo $prefix; ?>paddingleft" value="" />
							</div>
						</div>
					</div>
					<div class="menustyles-column" style="justify-content: center;position:relative;display:flex;margin-left:10px;">
						<div style="width:10px;height:40px;border-top:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;top:3px;"></div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>paddings.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>paddings" id="<?php echo $prefix; ?>paddings" size="1" value="" />
							</div>
						</div>
						<div style="width:10px;height:40px;border-bottom:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;bottom:3px;"></div>
					</div>
				</div>

			<?php if ($useheight OR $usewidth) { ?>
				<div class="menupanetitle<?php if ($expert == 'true') echo ' expert'; ?>"><?php echo \Joomla\CMS\Language\Text::_('CK_DIMENSIONS'); ?></div>
				<?php if ($usewidth) { ?>
				<div class="menustyles-row" style="justify-content: end;width:60%;">
					<div class="menustyles-text" style="margin: auto;">
						<?php echo \Joomla\CMS\Language\Text::_('CK_WIDTH'); ?>
					</div>
					<div class="menustyles-icon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-width" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" />
							<path d="M10 18h-7" />
							<path d="M21 18h-7" />
							<path d="M6 15l-3 3l3 3" />
							<path d="M18 15l3 3l-3 3" />
						  </svg>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>width" id="<?php echo $prefix; ?>width" value="" />
					</div>
				</div>
				<?php } ?>
				<?php if ($useheight) { ?>
				<div class="menustyles-row" style="justify-content: end;width:60%;">
					<div class="menustyles-text" style="margin: auto;">
						<?php echo \Joomla\CMS\Language\Text::_('CK_HEIGHT'); ?>
					</div>
					<div class="menustyles-icon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-height" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6" />
							<path d="M18 14v7" />
							<path d="M18 3v7" />
							<path d="M15 18l3 3l3 -3" />
							<path d="M15 6l3 -3l3 3" />
						  </svg>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>height" id="<?php echo $prefix; ?>height" value="" />
					</div>
				</div>
				<?php } ?>
			<?php } ?>

			<?php if ($iswrapper) { ?>
				<div class="menupanetitle" ><?php echo \Joomla\CMS\Language\Text::_('CK_FULLWIDTH'); ?></div>
				<div><?php echo \Joomla\CMS\Language\Text::_('CK_FULLWIDTH_DESC'); ?></div>
				<div class="menustyles-row" style="justify-content: end;width:60%;">
					<div class="menustyles-text">
						<?php echo \Joomla\CMS\Language\Text::_('CK_FULLWIDTH'); ?>
					</div>
					<div class="menustyles-icon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-width" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" />
							<path d="M10 18h-7" />
							<path d="M21 18h-7" />
							<path d="M6 15l-3 3l3 3" />
							<path d="M18 15l3 3l-3 3" />
						  </svg>
					</div>
					<div class="menustyles-field" >
						<select class="inputbox" name="<?php echo $prefix; ?>fullwidth" id="<?php echo $prefix; ?>fullwidth" >
							<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO') ?></option>
							<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES') ?></option>
						</select>
					</div>
				</div>
			<?php } ?>

				<div class="clr"></div>
			</div>
		</div>
		<?php
	}

	public function createDecoration($prefix) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_DECORATION'); ?></div>
			<div class="menustylesblockaccordion">

				<div class="menupanetitle" style=""><?php echo \Joomla\CMS\Language\Text::_('CK_BORDERS'); ?></div>
				<div class="menustyles-row">
					<div style="width:60px;justify-content: center;">
						<img style="flex:0;" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
					</div>
					<div style="width:50px;justify-content: center;">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-width" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" />
							<path d="M10 18h-7" />
							<path d="M21 18h-7" />
							<path d="M6 15l-3 3l3 3" />
							<path d="M18 15l3 3l-3 3" />
						  </svg>
					</div>
					<div style="width:60px;justify-content: center;">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-border-style-2" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 18v.01" />
							<path d="M8 18v.01" />
							<path d="M12 18v.01" />
							<path d="M16 18v.01" />
							<path d="M20 18v.01" />
							<path d="M18 12h2" />
							<path d="M11 12h2" />
							<path d="M4 12h2" />
							<path d="M4 6h16" />
						  </svg>
					</div>
				</div>

				<div class="menustyles-row">
					<div class="menustyles-column" style="width:60%">
						<div class="menustyles-row">
							<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>bordertopcolor" id="<?php echo $prefix; ?>bordertopcolor" style="width:55px;" />
							 <input class="inputbox ckresponsivable" type="text" style="border-top: 2px solid orange !important;" name="<?php echo $prefix; ?>bordertopsize" id="<?php echo $prefix; ?>bordertopsize" >
							 <select class="inputbox" style="width:70px;" name="<?php echo $prefix; ?>bordertopstyle" id="<?php echo $prefix; ?>bordertopstyle" >
								<option value="solid">solid</option>
								<option value="dotted">dotted</option>
								<option value="dashed">dashed</option>
							</select>
						</div>
						<div class="menustyles-row">
							<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderrightcolor" id="<?php echo $prefix; ?>borderrightcolor" style="width:55px;" />
							<input class="inputbox ckresponsivable" type="text" style="border-right: 2px solid orange !important;" name="<?php echo $prefix; ?>borderrightsize" id="<?php echo $prefix; ?>borderrightsize">

							<select class="inputbox" style="width:70px;" name="<?php echo $prefix; ?>borderrightstyle" id="<?php echo $prefix; ?>borderrightstyle" >
								<option value="solid">solid</option>
								<option value="dotted">dotted</option>
								<option value="dashed">dashed</option>
							</select>
						</div>
						<div class="menustyles-row">
							<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderbottomcolor" id="<?php echo $prefix; ?>borderbottomcolor" style="width:55px;" />
							<input class="inputbox ckresponsivable" type="text" style="border-bottom: 2px solid orange !important;" name="<?php echo $prefix; ?>borderbottomsize" id="<?php echo $prefix; ?>borderbottomsize">

							<select class="inputbox" style="width:70px;" name="<?php echo $prefix; ?>borderbottomstyle" id="<?php echo $prefix; ?>borderbottomstyle" >
								<option value="solid">solid</option>
								<option value="dotted">dotted</option>
								<option value="dashed">dashed</option>
							</select>
						</div>
						<div class="menustyles-row">
							<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderleftcolor" id="<?php echo $prefix; ?>borderleftcolor"style="width:55px;" />
							<input class="inputbox ckresponsivable" type="text" style="border-left: 2px solid orange !important;" name="<?php echo $prefix; ?>borderleftsize" id="<?php echo $prefix; ?>borderleftsize">

							<select class="inputbox" type="text" style="width:70px;" name="<?php echo $prefix; ?>borderleftstyle" id="<?php echo $prefix; ?>borderleftstyle" >
								<option value="solid">solid</option>
								<option value="dotted">dotted</option>
								<option value="dashed">dashed</option>
							</select>
						</div>
					</div>
					<div class="menustyles-column" style="position:relative;display:flex;flex-direction:column;margin-left:10px;justify-content: center;">
						<div style="width:10px;height:15px;border-top:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;top:3px;"></div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderscolor" id="<?php echo $prefix; ?>borderscolor" />
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-width" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" />
							<path d="M10 18h-7" />
							<path d="M21 18h-7" />
							<path d="M6 15l-3 3l3 3" />
							<path d="M18 15l3 3l-3 3" />
						  </svg>
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderssize" id="<?php echo $prefix; ?>borderssize" >
							</div>
						</div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-border-style-2" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
							<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
							<path d="M4 18v.01" />
							<path d="M8 18v.01" />
							<path d="M12 18v.01" />
							<path d="M16 18v.01" />
							<path d="M20 18v.01" />
							<path d="M18 12h2" />
							<path d="M11 12h2" />
							<path d="M4 12h2" />
							<path d="M4 6h16" />
						  </svg>
							</div>
							<div class="menustyles-field" >
								<select class="inputbox" name="<?php echo $prefix; ?>bordersstyle" id="<?php echo $prefix; ?>bordersstyle" >
									<option value="solid">solid</option>
									<option value="dotted">dotted</option>
									<option value="dashed">dashed</option>
								</select>
							</div>
						</div>
						<div style="width:10px;height:15px;border-bottom:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;bottom:3px;"></div>
					</div>
				</div>
				<p>&nbsp;</p>
				<div class="menupanetitle"><?php echo \Joomla\CMS\Language\Text::_('CK_ROUNDED_CORNERS'); ?></div>
				<div class="menustyles-row">
					<div class="menustyles-column" style="width:60%;">
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_TOPRIGHT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>topright_corner.svg" width="16" height="16" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderradiustopright" id="<?php echo $prefix; ?>borderradiustopright" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOMRIGHT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>bottomright_corner.svg" width="16" height="16" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderradiusbottomright" id="<?php echo $prefix; ?>borderradiusbottomright" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOMLEFT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>bottomleft_corner.svg" width="16" height="16" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderradiusbottomleft" id="<?php echo $prefix; ?>borderradiusbottomleft" value="" />
							</div>
						</div>
						<div class="menustyles-row" style="justify-content: end;">
							<div class="menustyles-text" style="margin: auto;">
								<?php echo \Joomla\CMS\Language\Text::_('CK_TOPLEFT'); ?>
							</div>
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>topleft_corner.svg" width="16" height="16" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderradiustopleft" id="<?php echo $prefix; ?>borderradiustopleft" value="" />
							</div>
						</div>
					</div>
					<div class="menustyles-column" style="justify-content: center;position:relative;display:flex;margin-left:10px;">
						<div style="width:10px;height:40px;border-top:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;top:3px;"></div>
						<div class="menustyles-row">
							<div class="menustyles-icon">
								<img src="<?php echo $this->imagespath; ?>corners.svg" width="20" height="20" />
							</div>
							<div class="menustyles-field" >
								<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderradius" id="<?php echo $prefix; ?>borderradius" size="1" value="" style="" />
							</div>
						</div>
						<div style="width:10px;height:40px;border-bottom:1px solid #ccc;border-right:1px solid #ccc;position:absolute;left:0;bottom:3px;"></div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}

	public function createSingleBorders($prefix) {
		?>
		<div class="menupanetitle" style="clear:both"><?php echo \Joomla\CMS\Language\Text::_('CK_BORDERS'); ?></div>
		<div class="ckoption">
			<div class="menustyles-row">
				<div style="width:155px;justify-content: center;">
					<img style="flex:0;" src="<?php echo $this->imagespath; ?>color.png" width="15" height="15" align="top" />
				</div>
				<div style="width:50px;justify-content: center;">
					<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-autofit-width" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
						<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
						<path d="M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" />
						<path d="M10 18h-7" />
						<path d="M21 18h-7" />
						<path d="M6 15l-3 3l3 3" />
						<path d="M18 15l3 3l-3 3" />
					  </svg>
				</div>
				<div style="width:60px;justify-content: center;">
					<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-border-style-2" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
						<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
						<path d="M4 18v.01" />
						<path d="M8 18v.01" />
						<path d="M12 18v.01" />
						<path d="M16 18v.01" />
						<path d="M20 18v.01" />
						<path d="M18 12h2" />
						<path d="M11 12h2" />
						<path d="M4 12h2" />
						<path d="M4 6h16" />
					  </svg>
				</div>
			</div>
			<div class="menustyles-row">
				<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>borderscolor" id="<?php echo $prefix; ?>borderscolor" style="width:155px;" />
				 <input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>borderssize" id="<?php echo $prefix; ?>borderssize" >
				 <select class="inputbox" style="width:70px;" name="<?php echo $prefix; ?>bordersstyle" id="<?php echo $prefix; ?>bordersstyle" >
					<option value="solid">solid</option>
					<option value="dotted">dotted</option>
					<option value="dashed">dashed</option>
				</select>
			</div>
		</div>
		<?php
	}

	public function createShadow($prefix) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_SHADOW'); ?></div>
			<div class="menustylesblockaccordion">
				<input class="inputbox ckresponsivable" type="hidden" value="" name="<?php echo $prefix; ?>shadowbefore" id="<?php echo $prefix; ?>shadowbefore" />
				<input class="inputbox ckresponsivable" type="hidden" value="" name="<?php echo $prefix; ?>shadowafter" id="<?php echo $prefix; ?>shadowafter" />
				<input class="inputbox ckresponsivable" type="hidden" value="" name="<?php echo $prefix; ?>shadowcustom" id="<?php echo $prefix; ?>shadowcustom" />
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label" style="width:30%">
						<?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?>
					</div>
					<div class="menustyles-icon">
						<img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>shadowcolor" id="<?php echo $prefix; ?>shadowcolor" />
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label" style="width:30%">
						<?php echo \Joomla\CMS\Language\Text::_('CK_OPACITY'); ?>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable ckrangeinputupdate" type="range" min="0" max="100" step="10" value="" name="<?php echo $prefix; ?>shadowopacity" id="<?php echo $prefix; ?>shadowopacity" style="width:165px;" />
						<input type="text" onchange="ckUpdateRangeInputs(this)" />
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label" style="width:30%">
						<?php echo \Joomla\CMS\Language\Text::_('CK_BLUR'); ?>
					</div>
					<div class="menustyles-icon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-blur" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M12 21a9.01 9.01 0 0 0 2.32 -.302a9 9 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z" />
  <path d="M12 3v17" />
  <path d="M12 12h9" />
  <path d="M12 9h8" />
  <path d="M12 6h6" />
  <path d="M12 18h6" />
  <path d="M12 15h8" />
</svg>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>shadowblur" id="<?php echo $prefix; ?>shadowblur" size="1" value="" />
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label" style="width:30%">
						<?php echo \Joomla\CMS\Language\Text::_('CK_SPREAD'); ?>
					</div>
					<div class="menustyles-icon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-table-filled" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M4 11h4a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-2a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a1 1 0 0 1 1 -1z" stroke-width="0" fill="currentColor" />
  <path d="M21 12v6a3 3 0 0 1 -2.824 2.995l-.176 .005h-6a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1z" stroke-width="0" fill="currentColor" />
  <path d="M18 3a3 3 0 0 1 2.995 2.824l.005 .176v2a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h6z" stroke-width="0" fill="currentColor" />
  <path d="M9 4v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-2a3 3 0 0 1 2.824 -2.995l.176 -.005h2a1 1 0 0 1 1 1z" stroke-width="0" fill="currentColor" />
</svg>
					</div>
					<div class="menustyles-field" >
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>shadowspread" id="<?php echo $prefix; ?>shadowspread" size="1" value="" />					
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-text" style="width: 10%;justify-content: center;">
						<?php echo \Joomla\CMS\Language\Text::_('x'); ?>
					</div>
					<div class="menustyles-field" style="width: 40%">
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>shadowoffseth" id="<?php echo $prefix; ?>shadowoffseth" size="1" value="" placeholder="0" />
					</div>
					<div class="menustyles-text" style="width: 10%;justify-content: center;">
						<?php echo \Joomla\CMS\Language\Text::_('y'); ?>
					</div>
					<div class="menustyles-field" style="width: 40%">
						<input class="inputbox ckresponsivable" type="text" name="<?php echo $prefix; ?>shadowoffsetv" id="<?php echo $prefix; ?>shadowoffsetv" size="1" value="" placeholder="0" />
					</div>
				</div>
				<div class="menustyles-row">
					<div class="menustyles-text menustyles-text-label" style="width:30%">
						<?php echo \Joomla\CMS\Language\Text::_('CK_DIRECTION'); ?>
					</div>
					<div class="menustyles-field menustyles-field-large">
						<select class="inputbox ckresponsivable" type="list" name="<?php echo $prefix; ?>shadowinset" id="<?php echo $prefix; ?>shadowinset" value="" style="width:105px;" >
							<option value="0"><?php echo \Joomla\CMS\Language\Text::_('CK_OUTSIDE'); ?></option>
							<option value="1"><?php echo \Joomla\CMS\Language\Text::_('CK_INSIDE'); ?></option>
						</select>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
	
	public function createIconText($prefix, $showlinks = true) {
		?>
		<div class="menustylesblock" >
			<div class="menustylesblocktitle"><?php echo \Joomla\CMS\Language\Text::_('CK_TEXT'); ?></div>
			<div class="menustylesblockaccordion">
				<div class="menupaneblock">
					<div style="float:left;">
						<div class="menupanetitle" style="width:200px;text-align:center;"><?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?></div>
						<div style="float:left;margin:0px 0 0 0px;clear:both;">
							<div>
								<div style="float:left;"><input class="inputbox ckresponsivable colorPicker" type="text" value="" name="<?php echo $prefix; ?>color" id="<?php echo $prefix; ?>color" size="6" style="width:52px;"/></div><div style="float:left;margin:5px 5px 0 2px;"><img src="<?php echo $this->imagespath; ?>color.png" width="15" height="15"/></div>
							</div>
							<div style="clear:both;">
								<input class="inputbox ckresponsivable" style="width: 40px;" name="<?php echo $prefix; ?>fontsize" id="<?php echo $prefix; ?>fontsize" />
								<div style="text-align:left;display:inline;"><?php echo \Joomla\CMS\Language\Text::_('CK_SIZE'); ?></div>
							</div>
						</div>
						<div style="clear:both;"></div>
					</div>
				</div>
				<div class="clr"></div>
			</div>
		</div>
		<?php
	}

	public function createEffects($prefix) {
	?>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_DURATION'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox <?php echo $prefix; ?>" type="text" name="<?php echo $prefix; ?>fxdur" id="<?php echo $prefix; ?>fxdur" value="1" />
				<span class="ckoption-suffix">s</span>
			</span>
			<div class="clr"></div>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<img class="ckoption-icon" src="<?php echo $this->imagespath; ?>hourglass.png" width="16" height="16" />
				<?php echo \Joomla\CMS\Language\Text::_('CK_DELAY'); ?></span>
			<span class="ckoption-field">
				<input class="inputbox <?php echo $prefix; ?>" type="text" name="<?php echo $prefix; ?>fxdelay" id="<?php echo $prefix; ?>fxdelay" value="0" />
				<span class="ckoption-suffix">s</span>
			</span>
			<div class="clr"></div>
		</div>
		<?php /*
		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_OTHER_EFFECTS'); ?></div>
		<div class="ckrow">
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxcolor" id="<?php echo $prefix; ?>fxcolor" value="" />
			<label for="<?php echo $prefix; ?>fxcolor" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_COLOR'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxfontsize" id="<?php echo $prefix; ?>fxfontsize" value="" />
			<label for="<?php echo $prefix; ?>fxfontsize" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_FONTSIZE'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxbackground" id="<?php echo $prefix; ?>fxbackground" value="" />
			<label for="<?php echo $prefix; ?>fxbackground" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_BACKGROUND'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxborder" id="<?php echo $prefix; ?>fxborder" value="" />
			<label for="<?php echo $prefix; ?>fxborder" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_BORDER'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxborderradius" id="<?php echo $prefix; ?>fxborderradius" value="" />
			<label for="<?php echo $prefix; ?>fxborderradius" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_BORDERRADIUS'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxshadow" id="<?php echo $prefix; ?>fxshadow" value="" />
			<label for="<?php echo $prefix; ?>fxshadow" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_SHADOW'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxmargin" id="<?php echo $prefix; ?>fxmargin" value="" />
			<label for="<?php echo $prefix; ?>fxmargin" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_MARGIN'); ?></label>
			<input class="inputbox <?php echo $prefix; ?>" style="display: none;" type="checkbox" name="<?php echo $prefix; ?>fxpadding" id="<?php echo $prefix; ?>fxpadding" value="" />
			<label for="<?php echo $prefix; ?>fxpadding" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_PADDING'); ?></label>
			
			<?php if ($prefix == 'image') { ?>
				<input class="inputbox image" style="display: none;" type="checkbox" name="overlayfxbackground" id="overlayfxbackground" value="" />
				<label for="overlayfxbackground" class="ckbutton"><?php echo \Joomla\CMS\Language\Text::_('CK_OVERLAY'); ?></label>
			<?php } ?>
		</div>
		 */ ?>
		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_OPACITY'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxopacity_enable" id="<?php echo $prefix; ?>fxopacity_enable" />
			<span class="ckoption-field">
				<input placeholder="0 to 1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>fxopacity" id="<?php echo $prefix; ?>fxopacity" value="1" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxopacity_enable" id="<?php echo $prefix; ?>hoverfxopacity_enable" />
			<span class="ckoption-field">
				<input placeholder="0 to 1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>hoverfxopacity" id="<?php echo $prefix; ?>hoverfxopacity" value="1" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>

		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_MOVE'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_DIRECTION'); ?>
			</span>
			<span class="ckoption-field">
				<select class="inputbox <?php echo $prefix; ?> hasTip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_DIRECTION'); ?>" type="list" name="<?php echo $prefix; ?>fxmovedir" id="<?php echo $prefix; ?>fxmovedir" value="" >
					<option value="ltrck"><?php echo \Joomla\CMS\Language\Text::_('CK_LEFT_TO_RIGHT'); ?></option>
					<option value="rtlck"><?php echo \Joomla\CMS\Language\Text::_('CK_RIGHT_TO_LEFT'); ?></option>
					<option value="ttbck"><?php echo \Joomla\CMS\Language\Text::_('CK_TOP_TO_BOTTOM'); ?></option>
					<option value="bttck"><?php echo \Joomla\CMS\Language\Text::_('CK_BOTTOM_TO_TOP'); ?></option>
				</select>
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxmovedist_enable" id="<?php echo $prefix; ?>fxmovedist_enable" />
			<span class="ckoption-field">
				<input placeholder="" class="inputbox <?php echo $prefix; ?> hasTip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_DISTANCE'); ?>" type="text" name="<?php echo $prefix; ?>fxmovedist" id="<?php echo $prefix; ?>fxmovedist" />
				<span class="ckoption-suffix">px</span>
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxmovedist_enable" id="<?php echo $prefix; ?>hoverfxmovedist_enable" />
			<span class="ckoption-field">
				<input placeholder="" class="inputbox <?php echo $prefix; ?>hover hasTip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_DISTANCE'); ?>" type="text" name="<?php echo $prefix; ?>hoverfxmovedist" id="<?php echo $prefix; ?>hoverfxmovedist" value="" />
				<span class="ckoption-suffix">px</span>
			</span>
		</div>
		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_ROTATE'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxrotrad_enable" id="<?php echo $prefix; ?>fxrotrad_enable" />
			<span class="ckoption-field">
				<input class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="-180" max="180" step="1" name="<?php echo $prefix; ?>fxrotrad" id="<?php echo $prefix; ?>fxrotrad" value="0" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxrotrad_enable" id="<?php echo $prefix; ?>hoverfxrotrad_enable" />
			<span class="ckoption-field">
				<input placeholder="0" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>hover" type="range" min="-180" max="180" step="1" name="<?php echo $prefix; ?>hoverfxrotrad" id="<?php echo $prefix; ?>hoverfxrotrad" value="0"  />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>

		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_SCALE'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxscale_enable" id="<?php echo $prefix; ?>fxscale_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="2" step="0.1" name="<?php echo $prefix; ?>fxscale" id="<?php echo $prefix; ?>fxscale" value="" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxscale_enable" id="<?php echo $prefix; ?>hoverfxscale_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>hover" type="range" min="0" max="2" step="0.1" name="<?php echo $prefix; ?>hoverfxscale" id="<?php echo $prefix; ?>hoverfxscale" value="" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>

		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_BLUR'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxblur_enable" id="<?php echo $prefix; ?>fxblur_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>fxblur" id="<?php echo $prefix; ?>fxblur" value="0" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxblur_enable" id="<?php echo $prefix; ?>hoverfxblur_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>hover" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>hoverfxblur" id="<?php echo $prefix; ?>hoverfxblur" value="0" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>

		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_BRIGHTNESS'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxbrightness_enable" id="<?php echo $prefix; ?>fxbrightness_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="2" step="0.1" name="<?php echo $prefix; ?>fxbrightness" id="<?php echo $prefix; ?>fxbrightness" value="1" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxbrightness_enable" id="<?php echo $prefix; ?>hoverfxbrightness_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>hover" type="range" min="0" max="2" step="0.1" name="<?php echo $prefix; ?>hoverfxbrightness" id="<?php echo $prefix; ?>hoverfxbrightness" value="1" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>

		<div class="ckheading"><?php echo \Joomla\CMS\Language\Text::_('CK_GRAYSCALE'); ?></div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_NORMAL_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>fxgrayscale_enable" id="<?php echo $prefix; ?>fxgrayscale_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>fxgrayscale" id="<?php echo $prefix; ?>fxgrayscale" value="0" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
		<div class="ckoption">
			<span class="ckoption-label">
				<?php echo \Joomla\CMS\Language\Text::_('CK_HOVER_STATE'); ?>
			</span>
			<input class="inputbox inputbox-enable" type="checkbox" name="<?php echo $prefix; ?>hoverfxgrayscale_enable" id="<?php echo $prefix; ?>hoverfxgrayscale_enable" />
			<span class="ckoption-field">
				<input placeholder="1" class="inputbox ckrangeinputupdate <?php echo $prefix; ?>hover" type="range" min="0" max="1" step="0.1" name="<?php echo $prefix; ?>hoverfxgrayscale" id="<?php echo $prefix; ?>hoverfxgrayscale" value="0" />
				<input type="text" onchange="ckUpdateRangeInputs(this)" />
			</span>
		</div>
	<?php
	}
}
