<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

use Pagebuilderck\CKModel;

class PagebuilderckModelBrowse extends CKModel {

	public function __construct() {
		parent::__construct();
	}

	/*
	 * Get a list of folders and files 
	 */
	public function getItemsList($type = 'image') {
		$input = \Joomla\CMS\Factory::getApplication()->input;

		$type = $input->get('type', $type, 'string');

		switch ($type) {
			case 'video' :
				$filetypes = array('.mp4', '.ogv', '.webm');
				break;
			case 'audio' :
				$filetypes = array('.mp3', '.ogg');
				break;
			case 'image' :
			default :
				$filetypes = array('.jpg', '.jpeg', '.png', '.gif', '.tiff', '.webp');
				break;
		}

		$folder = $input->get('folder', 'images', 'string');
		$tree = new stdClass();

		// look for all folder and files
		$this->getSubfolder(JPATH_SITE . '/' . $folder, $tree, implode('|', $filetypes), 1);

		$tree = $this->prepareList($tree);

		return $tree;
	}

	/* 
	 * List the subfolders and files according to the filter
	 */
	private function getSubfolder($folder, &$tree, $filter, $level) {
		$folders = \Joomla\CMS\Filesystem\Folder::folders($folder, '.', $recurse = false, $fullpath = true);

		if (! count($folders)) return;

		foreach ($folders as $f) {
			// list all authorized files from the folder
			$files = \Joomla\CMS\Filesystem\Folder::files($f, $filter, $recurse = false, $fullpath = false);
			$fName = \Joomla\CMS\Filesystem\File::makeSafe($f);
			$tree->$fName = new stdClass();
			$name = explode('/', $f);
			$name = end($name);
			$tree->$fName->name = $name;
			$tree->$fName->path = $f;
			$tree->$fName->files = $files;
			$tree->$fName->level = $level;

			// recursive loop
			$this->getSubfolder($f, $tree, $filter, $level+1);
		}
		return;
	}

	/* 
	 * Set level diff and check for depth
	 */
	private function prepareList($items) {
		if (! $items) return $items;

		$lastitem = 0;
		foreach ($items as $i => $item)
		{
			$item->deeper     = false;
			$item->shallower  = false;
			$item->level_diff = 0;

			if (isset($items->$lastitem))
			{
				$items->$lastitem->deeper     = ($item->level > $items->$lastitem->level);
				$items->$lastitem->shallower  = ($item->level < $items->$lastitem->level);
				$items->$lastitem->level_diff = ($items->$lastitem->level - $item->level);
			}
			$lastitem = $i;

			$item->basepath = str_replace(JPATH_SITE, '', $item->path);
			$item->basepath = str_replace('\\', '/', $item->basepath);
			$item->basepath = trim($item->basepath, '/');
		}

		return $items;
	}
}
