<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access.
defined('_JEXEC') or die;

use Pagebuilderck\CKModel;
use Pagebuilderck\CKFof;

class PagebuilderckModelFonts extends CKModel {

	protected $table = '#__pagebuilderck_fonts';

	var $item = null;

	function __construct() {
		parent::__construct();
	}

	/**
	 * Method to get an ojbect.
	 *
	 * @param	integer	The id of the object to get.
	 *
	 * @return	mixed	Object on success, false on failure.
	 */
	public function getItem($id = 0) {
		if (empty($this->item)) {
			$id = $this->input->get('id', $id, 'int');
			$this->item = CKFof::dbLoad($this->table, $id);
		}

		return $this->item;
	}

	/**
	 * 
	 * @param type $fontname
	 * @param type $url
	 * @param type $local
	 * @return mixed		The id on success, false on failure.
	 */
	public function saveFont($fontname, $url, $local, $filesize, $variants) {
		$data = array();
		$fontid = $this->searchExistingFont($fontname);
		$data['id'] = $fontid;
		$data['name'] = $fontname;
		$data['url'] = $url;
		$data['filesize'] = $filesize;
		$data['variants'] = $variants;
		$data['local'] = $local;
		$data['state'] = 1;

		return $this->save($data);
	}

	public function delete($fontname) {
		$id = $this->searchExistingFont($fontname);

		if (! $id) return false;
		return CKFof::dbDelete($this->table, $id);
	}

	/**
	 * 
	 * @param type $fontname
	 * @return int the font id or 0
	 */
	public function searchExistingFont($fontname) {
		// Create a new query object.
		$db = CKFof::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.id');
		$query->from('`#__pagebuilderck_fonts` AS a');
		$search = $db->Quote('%' .$fontname . '%');
		$query->where('(' . 'a.name LIKE ' . $search . ' )');
		$db->setQuery($query);

		$result = $db->loadResult();

		return (int)$result;
	}

	/**
	 * Method to save the page.
	 *
	 * @param	array		The form data.
	 * @return	mixed		The id on success, false on failure.
	 */
	public function save($data) {
		$id = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('font.id');
		$user = CKFof::getUser();

		if ($id) {
			//Check the user can edit this item
			$authorised = $user->authorise('core.edit', 'font.' . $id);
		} else {
			//Check the user can create new items in this section
			$authorised = $user->authorise('core.create', 'com_pagebuilderck');
		}

		if ($authorised !== true) {
			throw new Exception(\Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}


		$id = CKFof::dbStore($this->table, $data);
		return $id;
	}

	public function getItems() {
		// Create a new query object.
		$db = CKFof::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->from('`#__pagebuilderck_fonts` AS a');

		// Filter by search in title
		$search = $this->getState('filter_search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = ' . (int) substr($search, 3));
			} else if (stripos($search, 'type:') === 0) {
				$query->where('a.type = "' . (string) substr($search, 5) . '"');
			} else {
				$search = $db->Quote('%' .$search . '%');
				$query->where('(' . 'a.name LIKE ' . $search . ' )');
			}
		}

		// Do not list the trashed items
		$query->where('a.state > -1');

		// Add the list ordering clause.
		$orderCol = $this->state->get('filter_order');
		$orderDirn = $this->state->get('filter_order_Dir');
		if ($orderCol && $orderDirn) {
			$query->order($orderCol . ' ' . $orderDirn);
		}

		$limitstart = $this->state->get('limitstart');
		$limit = $this->state->get('limit');
		$db->setQuery($query, $limitstart, $limit);

		$items = $db->loadObjectList();

		// automatically get the total number of items from the query
		$total = $this->getTotal($query);
		$this->state->set('limit_total', (empty($total) ? 0 : (int)$total));

		return $items;
	}
}