<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Pagebuilderck\CKFof;

CKfof::addStyleSheet(PAGEBUILDERCK_MEDIA_URI . '/assets/pagebuilderck.css');
?>
<div class="ckadminsidebar"><?php echo \Joomla\CMS\HTML\Helpers\Sidebar::render() ?></div>
<div class="ckadminarea">
<?php
// check for the update
$latest_version = PagebuilderckHelper::getLatestVersion();
$isOutdated = PagebuilderckHelper::isOutdated();
if ($latest_version !== false) {
	if ($isOutdated) {
		echo '<p class="alertck">' . \Joomla\CMS\Language\Text::_('CK_IS_OUTDATED') . ' : <b>' . $latest_version . '</b></p>';
	} else {
		echo '<p class="infock">' . \Joomla\CMS\Language\Text::_('CK_IS_UPTODATE') . '</p>';
	}
}
?>
<style>
	.ckaboutversion {
		margin: 10px;
		padding: 10px;
		font-size: 20px;
		font-color: #000;
		text-align: center;
	}
	.ckcenter {
		margin: 10px 0;
		text-align: center;
	}
</style>
<div class="ckaboutversion"><?php echo \Joomla\CMS\Language\Text::_('CK_PAGEBUILDERCK_VERSION') . ' ' . $this->ckversion; ?> <?php echo (PagebuilderckHelper::getParams() ? 'PRO' : 'LIGHT') ?></div>
<div class="ckcenter"><img src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/images/logo_pagebuilderck_large_48.png" /></div>
<p class="ckcenter"><a href="https://www.joomlack.fr" target="_blank">https://www.joomlack.fr</a></p>
<p class="ckcenter"><?php echo \Joomla\CMS\Language\Text::_('CK_PAGEBUILDERCK_DESC'); ?></p>
<p class="ckcenter">Tabler Icons - https://tablericons.com/</p>
<div class="alert"><?php echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_VOTE_JED'); ?>&nbsp;<a href="https://extensions.joomla.org/extensions/extension/authoring-a-content/content-construction/page-builder-ck" target="_blank" class="btn btn-small btn-warning"><?php echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_VOTE_JED_BUTTON'); ?></a></div>
<div><?php echo PagebuilderckHelper::showParamsMessage(true, \Joomla\CMS\Language\Text::_('CK_PAGEBUILDERCK_GETMORE_PRO_ITEMS')); ?></div>
<hr />
<?php
PagebuilderckHelper::displayReleaseNotes();
?>
</div>