<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
 
// No direct access
defined('_JEXEC') or die;

use Pagebuilderck\CKView;
use Pagebuilderck\CKfof;

class PagebuilderckViewContenttype extends CKView {

	function display($tpl = null) {
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/menustyles.php';
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/stylescss.php';
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/ckeditor.php';
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/pagebuilderck.php';

		// get instance of the editor to load the css / js in the page
		$this->ckeditor = PagebuilderckHelper::loadEditor();

		$input = \Joomla\CMS\Factory::getApplication()->input;

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK'), 'home_pagebuilderck');

		$this->item = $this->get('Data');

		$user = \Joomla\CMS\Factory::getUser();
		$authorised = ($user->authorise('core.create', 'com_pagebuilderck') || (count($user->getAuthorisedCategories('com_pagebuilderck', 'core.create'))));

		if ($authorised !== true)
		{
			JError::raiseError(403, \Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		require_once JPATH_COMPONENT . '/helpers/pagebuilderck.php';

		\Joomla\CMS\Factory::getApplication()->input->set('hidemainmenu', true);
		$user		= \Joomla\CMS\Factory::getUser();
		$userId		= $user->get('id');
//		$isNew		= ($this->item->id == 0);
//		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
		$state = $this->get('State');
		$canDo = PagebuilderckHelper::getActions();

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK'));

		// For new records, check the create permission.
//		if ($isNew && $user->authorise('core.create', 'com_pagebuilderck'))
//		{
//			\Joomla\CMS\Toolbar\ToolbarHelper::apply('contenttype.apply');
//			\Joomla\CMS\Toolbar\ToolbarHelper::save('contenttype.save');
//			// \Joomla\CMS\Toolbar\ToolbarHelper::save2new('contenttype.save2new');
//			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('contenttype.cancel');
//		} else
//		{
			// Can't save the record if it's checked out.
//			if (!$checkedOut)
//			{
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId))
				{
					\Joomla\CMS\Toolbar\ToolbarHelper::apply('contenttype.apply');
					\Joomla\CMS\Toolbar\ToolbarHelper::save('contenttype.save');
//					\Joomla\CMS\Toolbar\ToolbarHelper::custom('contenttype.restore', 'archive', 'archive', 'CK_RESTORE', false);
					// We can save this record, but check the create permission to see if we can return to make a new one.
					if ($canDo->get('core.create'))
					{
						// \Joomla\CMS\Toolbar\ToolbarHelper::save2new('contenttype.save2new');
					}
				}
//			}

			// If checked out, we can still save
			if ($canDo->get('core.create'))
			{
				// \Joomla\CMS\Toolbar\ToolbarHelper::save2copy('contenttype.save2copy');
			}

			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('contenttype.cancel', 'JTOOLBAR_CLOSE');
//		}

		// \Joomla\CMS\Toolbar\ToolbarHelper::divider();
		// \Joomla\CMS\Toolbar\ToolbarHelper::help('JHELP_CONTENT_ARTICLE_MANAGER_EDIT');
	}
}
