<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

$user = \Joomla\CMS\Factory::getUser();
$app = \Joomla\CMS\Factory::getApplication();

$assoc = isset($app->item_associations) ? $app->item_associations : 0;
$canEdit = $user->authorise('core.edit', 'com_pagebuilderck');
$appendUrl = $this->input->get('layout', '', 'string') == 'modal' ? '&layout=modal&tmpl=component' : '&layout=edit';
// get global component params
// $params = \Joomla\CMS\Component\ComponentHelper::getParams('com_pagebuilderck');
// get item params
// if (! is_object($this->item->params)) $this->item->params = new \Joomla\Registry\Registry($this->item->params);
// merge params
// $params->merge($this->item->params);
$conf = \Joomla\CMS\Factory::getConfig();
?>
<div style="display:none;">
	<form>
		<?php
		// Load the editor Tinymce or JCE
		$editor = $conf->get('editor') == 'jce' ? 'jce' : 'tinymce';
		$editor = \Joomla\CMS\Editor\Editor::getInstance($editor);
		echo $editor->display('ckeditor', $html = '', $width = '', $height = '200px', $col = '', $row = '', $buttons = true, $id = 'ckeditor');
		?>
	</form>
</div>

<div id="mainck" class="container-fluid">

	<div id="maincktabcontent">

		<?php if ($canEdit) { ?>
			<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_pagebuilderck&view=page' . $appendUrl . '&id=' . $this->item->id); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data" class="form-validate ckinterface">
				<?php if (\Pagebuilderck\CKFof::isSite() && $app->input->get('layout') != 'modal') { ?>
					<div class="btn-toolbar">
						<div class="btn-group">
							<button type="button" class="btn btn-primary" onclick="Joomla.submitbutton('element.apply')">
								<span class="icon-apply"></span><?php echo \Joomla\CMS\Language\Text::_('JSAVE') ?>
							</button>
						</div>
						<div class="btn-group">
							<button type="button" class="btn btn-primary" onclick="Joomla.submitbutton('element.save')">
								<span class="icon-ok"></span><?php echo \Joomla\CMS\Language\Text::_('CK_SAVE_CLOSE') ?>
							</button>
						</div>
						<div class="btn-group">
							<button type="button" class="btn" onclick="Joomla.submitbutton('element.cancel')">
								<span class="icon-cancel"></span><?php echo \Joomla\CMS\Language\Text::_('JCANCEL') ?>
							</button>
						</div>
					</div>
				<?php } ?>

				<div class="mainmenulink menulink current" tab="tab_interface"><?php echo \Joomla\CMS\Language\Text::_('CK_EDITION'); ?></div>
				<div class="clr"></div>

				<div class="clearfix">
					<div>
						<label class="required" for="title" id="title-lbl">
							<?php echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_TITLE'); ?>
							<span class="star">&nbsp;*</span>
						</label>
						<input type="text" aria-required="true" required="required" size="40" class="input-xlarge input-large-text required" value="<?php echo $this->item->title ?>" id="title" name="title">
					</div>
					<div>
						<label class="required" for="description" id="description-lbl">
							<?php echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_DESCRIPTION'); ?>
						</label>
						<input type="text" size="40" class="input-xlarge input-large-text" value="<?php echo $this->item->description ?>" id="description" name="description">
					</div>
				</div>

				<input type="hidden" name="htmlcode" id="htmlcode" value="" />
				<input type="hidden" name="option" value="com_pagebuilderck" />
				<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
				<input type="hidden" name="task" value="" />
				<input type="hidden" name="controller" value="com_pagebuilderck" />
				<input type="hidden" name="return" value="<?php echo $this->input->getCmd('return'); ?>" />
				<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
			</form>
			<div class="maintab menustyles current ckproperty" id="tab_interface">
				<div id="workspaceparentck">
					<?php
					// loads the menu
					include_once(PAGEBUILDERCK_PATH . '/views/page/tmpl/contextmenu.php');
					include_once(PAGEBUILDERCK_PATH . '/views/page/tmpl/menu.php');
					include_once(PAGEBUILDERCK_PATH . '/views/page/tmpl/toolbar.php');
					?>
					<div id="workspaceck" class="workspaceck<?php echo (\Pagebuilderck\CKFof::isSite() ? ' pagebuilderckfrontend' : '') ?> ckelementedition">
						<?php
						if ($this->item->htmlcode) {
							echo $this->item->htmlcode;
						} else {
							?>

						<?php }
						?>
					</div>
				</div>
				<?php // load the modal for the restoration ?>
				<div id="pagebuilderckRestoreModalck" class="pagebuilderckRestoreModalck pagebuilderckModalck" style="display:none;">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">×</button>
						<h3><?php echo \Joomla\CMS\Language\Text::_('CK_RESTORE') ?></h3>
					</div>
					<div class="modal-body">
						<?php
						if ($this->item->id) {
							$path = JPATH_ROOT . '/administrator/components/com_pagebuilderck/backup/' . $this->item->id . '_bak';
							if (\Joomla\CMS\Filesystem\Folder::exists($path)) {
								$files = \Joomla\CMS\Filesystem\Folder::files($path, '.pbck', false, false);
								if (count($files)) {
									natsort($files);
									$i = 0;
									foreach ($files as $file) {
										if (stristr($file, 'locked_')) {
											$backupdate = str_replace('locked_' . $this->item->id . '_', '', \Joomla\CMS\Filesystem\File::stripExt($file));
											$isLocked = true;
										} else {
											$backupdate = str_replace('backup_' . $this->item->id . '_', '', \Joomla\CMS\Filesystem\File::stripExt($file));
											$isLocked = false;
										}
										$date = DateTime::createFromFormat('d-m-Y-G-i-s', $backupdate);
										$lockedIcon = $isLocked ? '<span class="ck-icon-lock"></span>' : '<span class="ck-icon-lock-open"></span>';

										echo '<div class="restoreline restoreline' . $i . ' clearfix">
								<span class="span6">
									<span class="label label-info">' . $date->format('d-M-Y H:i:s') . '</span>
								</span>
								<span class="span6">
									<span onclick="ckToggleLockedBackup(' . $this->item->id . ',\'' . $backupdate . '\', ' . $i . ')" data-locked="' . ($isLocked ? ' 1' : '0') . '" class="btn locked' . ($isLocked ? ' active' : '') . '" style="width:16px;margin:0 3px;display:inline-block;">' . $lockedIcon . '</span>
									<a class="btn" href="javascript:void(0)" onclick="ckDoRestoration(' . $this->item->id . ', \'' . $backupdate . '\', ' . $i . ')">
										' . \Joomla\CMS\Language\Text::_('CK_DO_RESTORATION') . '
									</a>
									<span class="processing" style="width:16px;margin:0 3px;display:inline-block;">&nbsp;</span>
									</span>
								</div>';
										$i++;
									}
								} else {
									echo '<div class="alert">' . \Joomla\CMS\Language\Text::_('CK_NO_RESTORE_FILE_FOUND') . '</div>';
								}
							} else {
								echo '<div class="alert">' . \Joomla\CMS\Language\Text::_('CK_NO_RESTORE_FILE_FOUND') . '</div>';
							}
						}
						?>
					</div>
				</div>
			<?php
			} else {
				if (!$canEdit)
					echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_NORIGHTS_TO_EDIT');
			}
			?>
		</div> <?php // fin tab_interface  ?>

	</div><?php // fin maincktabcontent  ?>
</div>
<script>
	$ck('#maincktabcontent div.maintab:not(.current)').hide();
	$ck('.mainmenulink', $ck('#mainck')).each(function (i, tab) {
		$ck(tab).click(function () {
			if ($ck('#popup_favoriteck').length) {
				ckCloseFavoritePopup(true);
			}
			$ck('#maincktabcontent div.maintab').hide();
			$ck('.mainmenulink', $ck('#mainck')).removeClass('current');
			if ($ck('#' + $ck(tab).attr('tab')).length)
				$ck('#' + $ck(tab).attr('tab')).show();
			$ck(this).addClass('current');
		});
	});
</script>
<?php
require(JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/views/page/tmpl/submitform.php');
