<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Pagebuilderck\CKView;
use Pagebuilderck\CKfof;

/**
 * View class for a list of Templateck.
 */
class PagebuilderckViewElements extends CKView {

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items = $this->get('Items');

		if (\Pagebuilderck\CKFof::isAdmin()) $this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		PagebuilderckHelper::loadCkbox();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		// Load the left sidebar only for Joomla 3 and under.
		if (! PAGEBUILDERCK_ISJ4) {
			PagebuilderckHelper::addSubmenu('elements');
		}

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK'));

		if (CKFof::userCan('core.create')) {
			// \Joomla\CMS\Toolbar\ToolbarHelper::addNew('element.add', 'JTOOLBAR_NEW');
		}

		if (CKFof::userCan('core.edit')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::editList('element.edit', 'JTOOLBAR_EDIT');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('element.copy', 'copy', 'copy', 'CK_COPY');
		}

		// if Params is installed
		if (PagebuilderckHelper::getParams()) {
			$importButton = '<button class="btn btn-small" onclick="CKBox.open({handler: \'inline\', content: \'ckImportModal\', fullscreen: false, size: {x: \'600px\', y: \'200px\'}});">
								<span class="icon-forward-2"></span>
								' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
							</button>';
			$bar->appendButton('Custom', $importButton, 'import');

			$exportButton = '<button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
								<span class="icon-share"></span>
								' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
							</button>';
			$bar->appendButton('Custom', $exportButton, 'export');

			// if (document.adminForm.boxchecked.value==0){alert('Veuillez d\'abord effectuer une s�lection dans la liste.');}else{ Joomla.submitbutton('pages.export')}
			// \Joomla\CMS\Toolbar\ToolbarHelper::custom('pages.export', 'share', 'share', 'CK_EXPORT', true);
			if ($importClass = PagebuilderckHelper::getParams('importelement')) {
				$importClass->loadImportForm();
			}
			if ($exportClass = PagebuilderckHelper::getParams('exportelement')) {
				$exportClass->loadExportForm();
			}
		} else {
			$importButton = '<button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
								<span class="icon-forward-2"></span>
								' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
							</button>';
			$bar->appendButton('Custom', $importButton, 'import');
			$exportButton = '<button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
								<span class="icon-share"></span>
								' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
							</button>';
			$bar->appendButton('Custom', $exportButton, 'export');
			echo PagebuilderckHelper::showParamsMessage(false);
		}

		if (CKFof::userCan('core.delete')) {
			//If this component does not use state then show a direct delete button as we can not trash
			// \Joomla\CMS\Toolbar\ToolbarHelper::custom('page.trash', 'trash', 'trash', 'JTOOLBAR_DELETE', 'test');
			$deleteButton = '<joomla-toolbar-button id="toolbar-cktrash" list-selection=""><button class="btn btn-small ' . (PAGEBUILDERCK_ISJ4 ? 'btn-danger' : '') . '" onclick="if (document.adminForm.boxchecked.value == 0) { alert(Joomla.JText._(\'JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST\')); } else { if (confirm(\'' . \Joomla\CMS\Language\Text::_('CK_CONFIRM_DELETE') . '\')) Joomla.submitbutton(\'element.trash\'); }">
									<span class="icon-trash"></span>
									' . \Joomla\CMS\Language\Text::_('CK_DELETE') . '
								</button></joomla-toolbar-button>';
			$bar->appendButton('Custom', $deleteButton, 'export');
		}

		if (CKFof::userCan('core.admin')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::preferences('com_pagebuilderck');
		}
	}
}
