<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

$input = new TCK_Input();
$prefix = $input->get('prefix', '', 'string');
?>
<style>
body {
	background: #fff;
}

#fontpreview {
	font-size: 28px;
	display: block;
	line-height: 1.5em;
	padding: 20px 0;
}

label {
	display: inline-block !important;
	min-width: 200px;
}

.fa-spinner {
	opacity: 0;
}
</style>
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckframework.css" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/font-awesome.min.css" type="text/css" />
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery.min.js" type="text/javascript"></script>

<div id="googlefontstyle"></div>
<div class="ckinterface" style="padding: 20px;">
	<p>
		<input id ="googlefonturl" name="googlefonturl" type="text" style="height:auto;margin:0;width: 500px;max-width:100%;" placeholder="<?php echo TCK_Text::_('CK_GOOGLEFONT_URL') ?>" onchange="searchgooglefont()" />
		<button class="ckbutton" onclick="searchgooglefont()"><span class="fa fa-search"></span> <?php echo TCK_Text::_('CK_SEARCH') ?></button><i class="fa fa-pulse fa-spinner"></i>
		<button class="ckbutton ckbutton-primary" onclick="returngooglefont()"><span class="fa fa-check"></span> <?php echo TCK_Text::_('CK_SELECT') ?></button>
	</p>
		<p><a class="ckalert ckalert-success" href="https://www.template-creator.com/en/documentation-category/12-interface/63-manage-google-fonts" target="_blank"><?php echo TCK_Text::_('CK_GOOGLE_FONT_DOCUMENTATION') ?></a></p>
	<hr />
	<input type="hidden" id="fonturl" name="fonturl" value="" />
	<p id="fontapplied"><label><?php echo TCK_Text::_('CK_FONT_APPLIED') ?></label> : <span id="fontappliedname" class="badge badge-success"><?php echo TCK_Text::_('CK_NONE') ?><span></p>
	<p id="fontweight"><label><?php echo TCK_Text::_('CK_FONTWEIGHT') ?></label> : <span class=""><input id="googlefontweight" name="googlefontweight" type="text" onchange="updatefontweight()" style="height:auto;margin:0;" placeholder="300" /><span></p>
	<p id="fontpreview">Grumpy wizards make toxic brew for the evil Queen and Jack.</p>
</div>
<script>
//<link href='https://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
// <link href='https://fonts.googleapis.com/css?family=Open+Sans&subset=latin,greek-ext' rel='stylesheet' type='text/css'>
//https://fonts.googleapis.com/css?family=Open+Sans
// Open+Sans
// Opens Sans
/* 
 * Test the given value and search for a google font
 * 
 * return void
 */
function searchgooglefont() {
	var url = jQuery('#googlefonturl').val();
	var name = ckCapitalize(jQuery('#googlefonturl').val()).trim("'");
	if (! url) {
		alert ('<?php echo TCK_Text::_('CK_EMPTY_URL', true) ?>');
		jQuery('#googlefonturl').addClass('invalid').focus();
		return;
	}
	jQuery('.fa-spinner').css('opacity', '1');
	var valuetest = /\+/;
	if ( url.indexOf("specimen") != -1 ) {
		name = url.split('=');
		name = name[1];
		getGooglefontFromFontvalue(name); 	// https://fonts.google.com/specimen/Dancing+Script?selection.family=Dancing+Script
	} else if ( url.indexOf("http") == 0 ) {
		getGooglefontFromUrl(url); 			// https://fonts.googleapis.com/css?family=Open+Sans:400,400italic,600
	} else if ( url.indexOf("<link") == 0 ) {
		getGooglefontFromStylesheet(url); 	// <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,400italic,600' rel='stylesheet' type='text/css'>
	} else if ( valuetest.test(url) ) {
		getGooglefontFromFontvalue(name); 	// Open+Sans
	} else {
		getGooglefontFromFontname(name); 	// Open Sans
	}
}
/* 
 * Load the font stylesheet from its url
 * @param : url - the http path to the stylesheet (https://fonts.googleapis.com/css?family=Open+Sans:400,400italic,600)
 * 
 * return : void
 */
function getGooglefontFromUrl(url) {
	jQuery.ajax({
		url: url,
	})
	.done(function( data ) {
		if (data) {
			jQuery('#googlefontstyle').html('<style>' + data + '</style>');
			var fontName = getNameFromContent(data).replace(/'/g, "");
			if (fontName) {
				jQuery('#fontappliedname').html(fontName);
				var re = /([0-9])*$/;
				var fontWeight = url.match(re);
				console.log(fontWeight);
				if (typeof(fontWeight[0]) != 'undefined') {
					jQuery('#googlefontweight').val(fontWeight[0]);
				}
				jQuery('#fonturl').val(url);
				updateFontPreview(fontName);
			}
		} else {
			alert( '<?php echo TCK_Text::_('CK_FONT_NOT_FOUND', true) ?>' );
		}
		jQuery('.fa-spinner').css('opacity', '0');
	})
	.fail(function() {
		alert( '<?php echo TCK_Text::_('CK_FONT_NOT_FOUND', true) ?>' );
		jQuery('.fa-spinner').css('opacity', '0');
	});
}

/* 
 * Load the font stylesheet from its stylesheet code
 * @param : url - the stylesheet code (<link href='https://fonts.googleapis.com/css?family=Open+Sans&subset=latin,greek-ext' rel='stylesheet' type='text/css'>)
 * 
 * return : String - the stylesheet content
 */
function getGooglefontFromStylesheet(stylesheet) {
	var re = /href='(.*?)'/;
	var url = stylesheet.match(re);
	if (typeof(url[1]) == 'undefined') {
		alert('<?php echo TCK_Text::_('CK_FONTURL_NOT_FOUND', true) ?>');
		return;
	}
	getGooglefontFromUrl(url[1].trim("'"));
}

/* 
 * Load the font stylesheet from its url
 * @param : url - the http path to the stylesheet (Open+Sans)
 * 
 * return : String - the stylesheet content
 */
function getGooglefontFromFontvalue(name) {
	var url = 'https://fonts.googleapis.com/css?family=' + name;
	getGooglefontFromUrl(url);
}

/* 
 * Load the font stylesheet from its url
 * @param : url - the http path to the stylesheet (Open Sans)
 * 
 * return : String - the stylesheet content
 */
function getGooglefontFromFontname(name) {
	names = name.split(' ');
	for (var i=0; i<names.length ; i++) {
		names[i] = ckCapitalize(names[i]);
	}
	name = names.join('+');
	getGooglefontFromFontvalue(name);
}

/*
 * Extract the name of the font from the google font styles
 * @param content : string - the font styles from google
 *
 * return string - the name
 */
function getNameFromContent(content) {
	// font-family:(.*?);
	var re = /font-family:(.*?);/;
	var fontName = content.match(re);
	if (typeof(fontName[1]) == 'undefined') {
		alert('<?php echo TCK_Text::_('CK_FONTNAME_NOT_FOUND', true) ?>');
		return '';
	}
	return fontName[1].trim().trim("'");
}

/*
 * Apply the font to the preview text
 * @param fontName : string - the font name
 *
 * return void
 */
function updateFontPreview(fontName) {
	jQuery('#fontpreview').css('font-family', fontName);
	updatefontweight();
}

/*
 * Apply the font weight to the preview text
 *
 * return void
 */
function updatefontweight() {
	jQuery('#fontpreview').css('font-weight', jQuery('#googlefontweight').val());
}

/*
 * Get the name and font weight and return them into the parent window
 *
 * return void
 */
function returngooglefont() {
//	if (! jQuery('#fonturl').val()) return;
	window.parent.ckSetGoogleFont('<?php echo $prefix ?>', jQuery('#fonturl').val(), jQuery('#fontappliedname').text(), jQuery('#googlefontweight').val());
	window.parent.CKBox.close();
}

function ckCapitalize(string) {
	return string.charAt(0).toUpperCase() + string.slice(1);
}
</script>


