<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

use Pagebuilderck\CKFof;

if (!defined('PAGEBUILDERCK_MEDIA_URI'))
{
	define('PAGEBUILDERCK_MEDIA_URI', \Joomla\CMS\Uri\Uri::root(true) . '/media/com_pagebuilderck');
}

require_once(PAGEBUILDERCK_PATH . '/helpers/defines.js.php');

$doc = \Joomla\CMS\Factory::getDocument();
$editor = \Joomla\CMS\Factory::getConfig()->get('pagebuilderck_replaced_editor', '') ? \Joomla\CMS\Factory::getConfig()->get('pagebuilderck_replaced_editor') : \Joomla\CMS\Factory::getConfig()->get('editor');
$editor = $editor == 'jce' ? 'jce' : 'tinymce';

$input = CKFof::getInput();
$params = \Joomla\CMS\Component\ComponentHelper::getParams('com_pagebuilderck');
?>
<link rel="stylesheet" href="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/pagebuilderck.css?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/ckframework.css?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/css" />
<?php // needs also to load the frontend styles to make the same visual as on frontend ?>
<link rel="stylesheet" href="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/components/com_pagebuilderck/assets/pagebuilderck.css?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/css" />
<link rel="stylesheet" href="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/colpick.css" type="text/css" />
<link rel="stylesheet" href="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/ckbox.css" type="text/css" />
<link rel="stylesheet" href="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/codemirrorck.css" type="text/css" />
<?php if ((int)$params->get('loadfontawesome','0') === 1) $doc->addStyleSheet(\Joomla\CMS\Uri\Uri::root(true) . '/components/com_pagebuilderck/assets/font-awesome.min.css'); ?>
<?php 
if (PAGEBUILDERCK_LOADEDITORCSS === '1') { 
	$defaultTemplate = PagebuilderckHelper::getDefaultTemplate();
	if (file_exists(JPATH_ROOT . '/templates/<?php echo $defaultTemplate ?>/css/editor.css')) {
	?>
	<link rel="stylesheet" href="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/templates/<?php echo $defaultTemplate ?>/css/editor.css" type="text/css" />
<?php
	}

	}
// call google fonts
$googlefontsFromTemplate = PagebuilderckHelper::loadTemplateGooglefonts();
$fonts = PagebuilderckHelper::getFonts();
if (! empty($googlefontsFromTemplate) && ! empty($googlefontsFromTemplate)) {
	?><link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin><?php
}
if (! empty($googlefontsFromTemplate)) {
	foreach ($googlefontsFromTemplate as $i => $gfont) {
		PagebuilderckHelper::loadTemplateGooglefontFile($gfont);
		/*
		?><link href="https://fonts.googleapis.com/css2?family=<?php echo $gfont ?>&display=swap" rel="stylesheet"><?php
		*/
	}
}
if (! empty($fonts)) {
	foreach ($fonts as $i => $font) {
		if ($font->local === 1) {
			$url = PagebuilderckHelper::getFontPath($font->name);
		?>	<link href="<?php echo $url ?>" rel="stylesheet"><?php
		} else { ?>
			<link href="<?php echo $font->url ?>" rel="stylesheet"><?php
		}
	}
}
?>
<script type="text/javascript">
	var URIROOT = PAGEBUILDERCK.URIROOT; // BC for old plugins
	var URIBASE = PAGEBUILDERCK.URIBASE; // BC for old plugins
	var CLIPBOARDCK = '';
	var CLIPBOARDCOLORCK = '';
	var BLOCCKSTYLESBACKUP = '';
	var FAVORITELOCKED = '';
	var JoomlaCK = {};
	var PAGEBUILDERCK_MEDIA_URI = '<?php echo PAGEBUILDERCK_MEDIA_URI ?>';
	var PAGEBUILDERCK_ADMIN_URL = '<?php echo PAGEBUILDERCK_ADMIN_URL ?>';
	//var PAGEBUILDERCK_TOKEN = cktoken = '<?php echo \Joomla\CMS\Factory::getSession()->getFormToken() ?>=1';
	var PAGEBUILDERCK_EDITOR = '<?php echo $editor ?>';
	PAGEBUILDERCK.ISCONTENTTYPE = '<?php echo $input->get('iscontenttype', 0, 'int') ?>';
</script>
<?php 
// modal view : strange that Joomla 4 do not want to load the script at the end in modal view
if ((version_compare(JVERSION,'4') <= 1) || $input->get('layout', '') === 'modal' || (CKFof::isSite() && $input->get('layout', '') === 'edit')) { ?>
<?php if (version_compare(JVERSION,'4') < 1) \Joomla\CMS\HTML\HTMLHelper::_('behavior.core'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/jqueryck.min.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/jquery-uick-custom.min.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/ckbox.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/codemirrorck.js'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/php.js'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/javascript.js'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/ckframework.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(\Joomla\CMS\Uri\Uri::root(true) . '/components/com_pagebuilderck/assets/jquery-uick.min.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/ckbrowse.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/colpick.js'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/pagebuilderck.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<style>
body > .container-fluid {
	padding-left: 35px;
}
</style>
<?php 
// normal view
} else { ?>
<?php CKFof::addScript(\Joomla\CMS\Uri\Uri::root(true) . '/components/com_pagebuilderck/assets/jquery-uick.min.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/ckbrowse.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/colpick.js'); ?>
<?php CKFof::addScript(PAGEBUILDERCK_MEDIA_URI . '/assets/pagebuilderck.js?ver=' . PAGEBUILDERCK_VERSION); ?>
<?php \Joomla\CMS\HTML\HTMLHelper::_('jquery.framework'); ?>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/jqueryck.min.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/jquery-uick-custom.min.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/ckbox.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/codemirrorck.js" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/php.js" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/javascript.js" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/css.js" type="text/javascript"></script>
<script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/ckframework.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script>
<?php } ?>

<?php 
// load the CK Framework
//require_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/ckframework.php';
//\Pagebuilderck\CKFramework::loadInline();

switch ($editor) {
	case 'jce':
			?><script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/editors/jce.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script><?php
		break;
	case 'tinymce':
	default:
		if (version_compare(JVERSION, '4') >= 0) { // check if we are in Joomla 3.7
			?><script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/editors/tinymce3.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script><?php
		} else if (version_compare(JVERSION, '3.7') >= 0) { // check if we are in Joomla 3.7
			?><script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/editors/tinymce2.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script><?php
		} else { // we are still in an old version
			?><script src="<?php echo PAGEBUILDERCK_MEDIA_URI ?>/assets/editors/tinymce1.js?ver=<?php echo PAGEBUILDERCK_VERSION ?>" type="text/javascript"></script><?php
		}
		break;
}

\Joomla\CMS\Language\Text::script('CK_CONFIRM_DELETE');
\Joomla\CMS\Language\Text::script('CK_FAILED_SET_TYPE');
\Joomla\CMS\Language\Text::script('CK_FAILED_SAVE_ITEM_ERRORMENUTYPE');
\Joomla\CMS\Language\Text::script('CK_ALIAS_EXISTS_CHOOSE_ANOTHER');
\Joomla\CMS\Language\Text::script('CK_FAILED_SAVE_ITEM_ERROR500');
\Joomla\CMS\Language\Text::script('CK_FAILED_SAVE_ITEM');
\Joomla\CMS\Language\Text::script('CK_FAILED_TRASH_ITEM');
\Joomla\CMS\Language\Text::script('CK_FAILED_CREATE_ITEM');
\Joomla\CMS\Language\Text::script('CK_UNABLE_UNPUBLISH_HOME');
\Joomla\CMS\Language\Text::script('CK_TITLE_NOT_UPDATED');
\Joomla\CMS\Language\Text::script('CK_LEVEL_NOT_UPDATED');
\Joomla\CMS\Language\Text::script('CK_SAVE_LEVEL_FAILED');
\Joomla\CMS\Language\Text::script('CK_SAVE_ORDER_FAILED');
\Joomla\CMS\Language\Text::script('CK_CHECKIN_NOT_UPDATED');
\Joomla\CMS\Language\Text::script('CK_CHECKIN_FAILED');
\Joomla\CMS\Language\Text::script('CK_PARAM_NOT_UPDATED');
\Joomla\CMS\Language\Text::script('CK_PARAM_UPDATE_FAILED');
\Joomla\CMS\Language\Text::script('CK_FIRST_CREATE_ROW');
\Joomla\CMS\Language\Text::script('CK_EDIT');
\Joomla\CMS\Language\Text::script('CK_ICON');
\Joomla\CMS\Language\Text::script('CK_MODULE');
\Joomla\CMS\Language\Text::script('CK_GOOGLE_FONT');
\Joomla\CMS\Language\Text::script('CK_FULLSCREEN');
\Joomla\CMS\Language\Text::script('CK_RESTORE');
\Joomla\CMS\Language\Text::script('CK_REMOVE_BLOCK');
\Joomla\CMS\Language\Text::script('CK_MOVE_BLOCK');
\Joomla\CMS\Language\Text::script('CK_EDIT_STYLES');
\Joomla\CMS\Language\Text::script('CK_DECREASE_WIDTH');
\Joomla\CMS\Language\Text::script('CK_INCREASE_WIDTH');
\Joomla\CMS\Language\Text::script('CK_ADD_BLOCK');
\Joomla\CMS\Language\Text::script('CK_REMOVE_ROW');
\Joomla\CMS\Language\Text::script('CK_EDIT_COLUMNS');
\Joomla\CMS\Language\Text::script('CK_MOVE_ROW');
\Joomla\CMS\Language\Text::script('CK_ADD_NEW_ROW');
\Joomla\CMS\Language\Text::script('CK_REMOVE_ITEM');
\Joomla\CMS\Language\Text::script('CK_REMOVE_ITEM');
\Joomla\CMS\Language\Text::script('CK_MOVE_ITEM');
\Joomla\CMS\Language\Text::script('CK_DUPLICATE_ITEM');
\Joomla\CMS\Language\Text::script('CK_DUPLICATE_ROW');
\Joomla\CMS\Language\Text::script('CK_EDIT_ITEM');
\Joomla\CMS\Language\Text::script('CK_ADD_COLUMN');
\Joomla\CMS\Language\Text::script('CK_DELETE');
\Joomla\CMS\Language\Text::script('CK_SAVE_CLOSE');
\Joomla\CMS\Language\Text::script('CK_DESIGN_SUGGESTIONS');
\Joomla\CMS\Language\Text::script('CK_MORE_MENU_ELEMENTS');
\Joomla\CMS\Language\Text::script('CK_FULLWIDTH');
\Joomla\CMS\Language\Text::script('CK_DUPLICATE_COLUMN');
\Joomla\CMS\Language\Text::script('CK_ENTER_CLASSNAMES');
\Joomla\CMS\Language\Text::script('CHECK_IDS_ALERT_PROBLEM');
\Joomla\CMS\Language\Text::script('CHECK_IDS_ALERT_OK');
\Joomla\CMS\Language\Text::script('CK_ENTER_UNIQUE_ID');
\Joomla\CMS\Language\Text::script('CK_INVALID_ID');
\Joomla\CMS\Language\Text::script('CK_ENTER_VALID_ID');
\Joomla\CMS\Language\Text::script('CK_CONFIRM_BEFORE_CLOSE_EDITION_POPUP');
\Joomla\CMS\Language\Text::script('CK_SUGGESTIONS');
\Joomla\CMS\Language\Text::script('CK_RESPONSIVE_SETTINGS_ALIGNED');
\Joomla\CMS\Language\Text::script('CK_RESPONSIVE_SETTINGS_STACKED');
\Joomla\CMS\Language\Text::script('CK_RESPONSIVE_SETTINGS_HIDDEN');
\Joomla\CMS\Language\Text::script('CK_SAVE');
\Joomla\CMS\Language\Text::script('CK_WRAPPER_IN_WRAPPER_NOT_ALLOWED');
\Joomla\CMS\Language\Text::script('CK_DUPLICATE_WRAPPER');
\Joomla\CMS\Language\Text::script('CK_MOVE_WRAPPER');
\Joomla\CMS\Language\Text::script('CK_REMOVE_WRAPPER');
\Joomla\CMS\Language\Text::script('CK_ADD_NEW_PAGEBUILDER_MODULE');
\Joomla\CMS\Language\Text::script('CK_ADD');
\Joomla\CMS\Language\Text::script('CK_DRAG_DROP_PAGE');
\Joomla\CMS\Language\Text::script('CK_PAGE');
\Joomla\CMS\Language\Text::script('CK_ACCESS_RIGHTS');
\Joomla\CMS\Language\Text::script('CK_CLIPBOARDEMPTY');
\Joomla\CMS\Language\Text::script('CK_COPYFROMCLIPBOARD');
\Joomla\CMS\Language\Text::script('CK_FIRST_CLEAR_VALUE');
\Joomla\CMS\Language\Text::script('CK_CLICK_TO_EDIT_CONTENT');
\Joomla\CMS\Language\Text::script('CK_CLEAN');
\Joomla\CMS\Language\Text::script('CK_SELECT');
\Joomla\CMS\Language\Text::script('CK_CONFIRM_CLEAR_STYLES');
\Joomla\CMS\Language\Text::script('CK_VALIGN_DEFAULT');
\Joomla\CMS\Language\Text::script('CK_VALIGN_TOP');
\Joomla\CMS\Language\Text::script('CK_VALIGN_CENTER');
\Joomla\CMS\Language\Text::script('CK_VALIGN_BOTTOM');
\Joomla\CMS\Language\Text::script('CK_FONT_ICON');
\Joomla\CMS\Language\Text::script('CK_SVG_ICON');
?>
<script type="text/javascript">
	function ckKeepAlive() {
		$ck.ajax({type: "POST", url: "index.php"});
	}

	<?php if (! PagebuilderckHelper::getParams()) { ?>
	function ckShowFavoritePopup() {
		CKBox.open({handler:'inline',content: 'pagebuilderckparamsmessage', fullscreen: false, size: {x: '600px', y: '150px'}});
	}
	function ckShowLibraryPopup() {
		CKBox.open({handler:'inline',content: 'pagebuilderckparamsmessage', fullscreen: false, size: {x: '600px', y: '150px'}});
	}
	<?php } ?>

	$ck(document).ready(function()
	{
		CKApi.Tooltip('.cktip');
		window.setInterval("ckKeepAlive()", 600000);
	});
</script>
<style>
	.tox.tox-silver-sink.tox-tinymce-aux {z-index: 99999}
	#ckeditor_ArticleModal {z-index: 99999};
	
</style>
