<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');
$app = \Joomla\CMS\Factory::getApplication();
$input = $app->input;

// load the custom plugins
\Joomla\CMS\Plugin\PluginHelper::importPlugin( 'pagebuilderck' );
//$dispatcher = JEventDispatcher::getInstance();
?>
<style type="text/css">
<?php if ($input->get('view', '', 'string') === 'style') { ?>
.menuckpanel[data-target="pages"],
.menuckpanel[data-target="library"] {
	display: none !important;
}
<?php } ?>
<?php if ($input->get('iscontenttype', 0, 'int') !== 1) { ?>
body {
	margin-left: 310px;
	filter: none !important;
}
<?php } ?>

body.hidepanel {
	margin-left: 50px;
}

body.hidepanel .menuck {
	width: 50px;
	overflow: hidden;
}

body.hidepanel #togglepanel ~ *,
body.hidepanel .menuckpanel,
body.hidepanel .menuckpanelfake {
	display: none;
}

body.hidepanel #togglepanel {
	width: 50px;
	transform: rotate(180deg);
}

body.tck-edition-body {
	margin-left: 310px;
	width: calc(100% - 310px);
}

.menuck {
	background-color: #f5f5f5;
	border: none;
	display: block;
	left: 0;
	padding: 0 0 10px 0px;
	width: 310px;
	box-sizing: border-box;
	z-index: 1039;
	position: fixed;
	top: 0;
	bottom: 0;
	overflow-y: scroll;
	overflow-x: hidden;
	margin: 0;
	font-family: Segoe UI, arial;
}

.menuck .menuckinfos {
	margin: 5px 0;
	padding: 5px;
	font-size: 12px;
	line-height: 12px;
}

.menuck .menuitemck:hover {
	border: 1px solid #ddd;
}

.menuck img {
	margin: 1px;
}

.menuck .menuitemck, .workspaceck .menuitemck {
	background: #fff none repeat scroll 0 0;
	border: 1px solid #f2f2f2;
	float: left;
	height: 40px;
	margin: 5px 0 0 5px;
	padding: 5px;
	width: 47%;
	max-width: 125px;
	cursor: grab;
	cursor: -webkit-grab;
	box-sizing: border-box;
	border-radius: 4px;
}

.menuck .menuitemck.grabbing, .workspaceck .menuitemck.grabbing {
	cursor: grabbing;
	cursor: -webkit-grabbing;
}

.menuck .menuitemck .menuitemck_title, .workspaceck .menuitemck .menuitemck_title {
	font-size: 12px;
	line-height: 15px;
	align-self: center;
}

.menuck .menuitemck .menuitemck_desc, .workspaceck .menuitemck .menuitemck_desc {
	color: #1a1a1a;
	font-size: 10px;
}

.menuck .menuitemck > div, .workspaceck .menuitemck > div {
	float: right;
	width: calc(100% - 28px);
	height: 28px;
	display: flex;
}

.menuck .menuitemck img, .workspaceck .menuitemck img {
	float: left;
	margin: 5px 0 0 2px;
	width: 20px;
	opacity: 0.6;
}

.menuitemck_group {
	clear: both;
	padding: 2px 5px;
	text-transform: capitalize;
	border-bottom: 2px solid #2E5A84;
	color: #2E5A84;
	margin: 5px 5px 0;
	font-size: 12px;
	font-weight: bold;
	cursor: pointer;
}

.menuck .headerck {
	cursor: pointer;
	padding: 0 0 0 5px;
	background: none;
	font-size: 18px;
	min-height: 40px;

}

.menuck .ckinterface {
	background: none;
}

#workspaceparentck.collapsedck .menuck {
	width: 75px;
}

#workspaceparentck.collapsedck .menuck .headercktext,
#workspaceparentck.collapsedck .menuck .menuckinfos,
#workspaceparentck.collapsedck .menuck .menuitemck > div,
#workspaceparentck.collapsedck .menuck .menuitemck_title,
#workspaceparentck.collapsedck .menuck .menuitemck_desc {
	display: none;
}

#workspaceparentck.collapsedck .menuck .menuitemck {
	width: 50px;
	height: 50px;
	margin: 5px 2px;
}

/*#workspaceparentck:not(.collapsedck) #workspaceck {
	margin-left: 235px;
}

#module-form #workspaceparentck:not(.collapsedck) #workspaceck {
	margin-left: 260px;
}*/

.menuck .headercktext {
	display: inline-block;
	width: 145px;
	line-height: 32px;
	vertical-align: top;
	padding-left: 5px;
	margin-top: 5px;
	font-weight: 600;
	color: #2E5A84;
}

.menuck .menuckinner {
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	height: 100%;
}

.menuck > .inner {
	/*position: relative;*/
	max-height: 100%;
	height: calc(100vh - 50px);
	overflow-y: auto;
	margin-left: 50px;
}

.menuck > .inner:not(.ckelementsedition) {
	display: none;
}

.menuck .ckcolumnsedition {
	display: none;
}

.menuck .headerckicon {
	width: 40px;
	height: 40px;
	float: right;
	display: inline-block;
	box-sizing: border-box;
	line-height: 32px;
	padding: 0;
	background: none;
	color: #000;
	font-size: 1.3em;
	border: none;
	text-align: center;
	cursor: pointer;
	font-weight: normal;
	border-radius: 0;
	opacity: 0.7;
}

.menuck .headerckicon:hover {
	color: #000;
	opacity: 1;
}

.collapsedck .menuck .headerckicon {
	transform: rotate(180deg);
}

.menuck .headerckicon.cksave,
.menuck .headerckicon.ckclean {
	font-size: 13px;
	line-height: 35px;
}

.menuck input {
	width: auto;
	margin-left: 5px;
}

.menuck .ckresponsivebutton {
	border: 1px solid #ddd;
	border-radius: 4px;
	box-shadow: none;
	width: 205px;
	margin-left: 0;
}

.menuck .ckresponsivebutton.active {
	border-color: #faa732;
}

.menuck .ckbutton-group .ckresponsivebutton:not(#ckresponsive5button) {
	border-radius: 4px 0 0 4px;
	height: 30px;
}

.menuck .ckbutton-group .ckresponsivebutton ~ .ckresponsivebutton:not(#ckresponsive5button) {
	border-radius: 0 4px 4px 0;
}

#popup_editionck .menulink {
	background: #fff;
	border: none;
	border-bottom: 1px solid #ddd;
	padding: 10px 10px 10px 14px;
	border-radius: 0px;
	border-left: 4px solid #fff;
	font-weight: 600;
	font-size: 16px;
	color: #555;
	font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;
}

#popup_editionck .menulink:hover,
#popup_editionck .menulink.open{
	color: #0073aa;
	background: #f8f8f8;
	border-bottom: 1px solid #0073aa;
}

/* Fix for Safari */
.ckpopup, .menuck {
	overflow: visible !important;
}

.menuckpanels {
	width: 50px;
	background: #1C3D5C;
	height: calc(100vh - 40px);
	float: left;
}

.menuckpanelfake img,
.menuckpanel img {
	margin: 8px;
}

.menuckpanel svg, .menuckpanelfake svg {
	width: 24px;
	height: 24px;
	fill: #fff;
	opacity: 0.5;
}

.menuckpanel.active svg {
	opacity: 1;
}

.menuckpanelfake,
.menuckpanel {
	color: #ddd;
	text-align: center;
	padding: 12px 0;
}

.menuckpanelfake .fa,
.menuckpanel .fa {
	font-size: 24px;
}

.menuckpanelfake.active, .menuckpanelfake:hover,
.menuckpanel.active, .menuckpanel:hover {
	background: #2E5A84;
	color: #fff;
	cursor: pointer;
}

.menuckbootomtoolbar {
	height: 40px;
	background: #2E5A84;
	position: absolute;
	bottom: 0;
	width: 100%;
	left: 0;
	text-align: center;
	display: flex;
	justify-content: center;
	padding-left: 40px;
}

.menuckbootomtoolbar span.menuckbootomtoolbar-button {
	height: 40px;
	width: 40px;
	border-radius: 0;
	margin: 0;
	padding: 0;
	line-height: 40px;
	color: #fff;
	padding: 0 10px;
	opacity: 0.7;
	display: inline-block;
	cursor: pointer;
	font-size: 16px;
}

.menuckbootomtoolbar span.menuckbootomtoolbar-button:hover, .menuckbootomtoolbar span.menuckbootomtoolbar-button.active {
	opacity: 1;
}

.menuckbootomtoolbar a:before {
	display: none;
}

.ckresponsivebutton {
	width: 170px;
}

.ckmyelements.headerck {
	margin-top: 10px;
}

.ckaddonsdisplaytype {
	display: none;
}

#cklibraryiframe {
	padding: 10px;
}
<?php
$displaytype = $app->getUserState('pagebuilderck.addons.displaytype', 'list');
echo '#ckaddonsdisplaytype' . $displaytype . ' { display: block; }';
?>
</style>
<?php
// get global component params
$componentParams = \Joomla\CMS\Component\ComponentHelper::getParams('com_pagebuilderck');
$view = $input->get('view', 'page');
?>
<?php 
if ($input->get('iscontenttype', 0, 'int') !== 1) { ?>
<div id="menuck" class="menuck clearfix ckinterface">
	<div class="menuckpanels">
		<div class="menuckpanel cktip active" data-target="addons" title="<?php echo \Joomla\CMS\Language\Text::_('CK_ADDONS') ?>" data-placement="right">
			<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1728 1098q0 81-44.5 135t-123.5 54q-41 0-77.5-17.5t-59-38-56.5-38-71-17.5q-110 0-110 124 0 39 16 115t15 115v5q-22 0-33 1-34 3-97.5 11.5t-115.5 13.5-98 5q-61 0-103-26.5t-42-83.5q0-37 17.5-71t38-56.5 38-59 17.5-77.5q0-79-54-123.5t-135-44.5q-84 0-143 45.5t-59 127.5q0 43 15 83t33.5 64.5 33.5 53 15 50.5q0 45-46 89-37 35-117 35-95 0-245-24-9-2-27.5-4t-27.5-4l-13-2q-1 0-3-1-2 0-2-1v-1024q2 1 17.5 3.5t34 5 21.5 3.5q150 24 245 24 80 0 117-35 46-44 46-89 0-22-15-50.5t-33.5-53-33.5-64.5-15-83q0-82 59-127.5t144-45.5q80 0 134 44.5t54 123.5q0 41-17.5 77.5t-38 59-38 56.5-17.5 71q0 57 42 83.5t103 26.5q64 0 180-15t163-17v2q-1 2-3.5 17.5t-5 34-3.5 21.5q-24 150-24 245 0 80 35 117 44 46 89 46 22 0 50.5-15t53-33.5 64.5-33.5 83-15q82 0 127.5 59t45.5 143z"/></svg>
		</div>
		<?php if ($pagebuilderckParams->get('enablepanel_pages', '1', 'int') !== '0') { ?>
		<div class="menuckpanel cktip" data-target="pages" title="<?php echo \Joomla\CMS\Language\Text::_('CK_LOAD_PAGE') ?>" data-placement="right">
			<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1596 380q28 28 48 76t20 88v1152q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h896q40 0 88 20t76 48zm-444-244v376h376q-10-29-22-41l-313-313q-12-12-41-22zm384 1528v-1024h-416q-40 0-68-28t-28-68v-416h-768v1536h1280zm-1024-864q0-14 9-23t23-9h704q14 0 23 9t9 23v64q0 14-9 23t-23 9h-704q-14 0-23-9t-9-23v-64zm736 224q14 0 23 9t9 23v64q0 14-9 23t-23 9h-704q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h704zm0 256q14 0 23 9t9 23v64q0 14-9 23t-23 9h-704q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h704z"/></svg>
		</div>
		<?php } ?>
		<?php if ($pagebuilderckParams->get('enablepanel_styles', '1', 'int') !== '0') { ?>
		<?php if ($view !== 'element') { ?>
		<div class="menuckpanel cktip" data-target="styles" title="<?php echo \Joomla\CMS\Language\Text::_('CK_LOAD_STYLE') ?>" data-placement="right">
			<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1615 0q70 0 122.5 46.5t52.5 116.5q0 63-45 151-332 629-465 752-97 91-218 91-126 0-216.5-92.5t-90.5-219.5q0-128 92-212l638-579q59-54 130-54zm-909 1034q39 76 106.5 130t150.5 76l1 71q4 213-129.5 347t-348.5 134q-123 0-218-46.5t-152.5-127.5-86.5-183-29-220q7 5 41 30t62 44.5 59 36.5 46 17q41 0 55-37 25-66 57.5-112.5t69.5-76 88-47.5 103-25.5 125-10.5z"/></svg>
		</div><?php } ?>
		<div class="menuckpanel cktip" data-target="library" title="<?php echo \Joomla\CMS\Language\Text::_('CK_LOAD_MODEL') ?>" data-placement="right">
			<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68z"/></svg>
		</div>
		<?php } ?>
		<?php if ($input->get('tckedition', 0, 'int') == 0) { ?>
			<?php if ($pagebuilderckParams->get('enablepanel_responsive', '1', 'int') !== '0') { ?>
			<div id="ckresponsivesettingsbutton" data-target="responsive" class="menuckpanel cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_RESPONSIVE_SETTINGS') ?>" data-placement="right">
				<svg style="width:36px;height:36px;" width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M976 1408q0-33-23.5-56.5t-56.5-23.5-56.5 23.5-23.5 56.5 23.5 56.5 56.5 23.5 56.5-23.5 23.5-56.5zm208-160v-704q0-13-9.5-22.5t-22.5-9.5h-512q-13 0-22.5 9.5t-9.5 22.5v704q0 13 9.5 22.5t22.5 9.5h512q13 0 22.5-9.5t9.5-22.5zm-192-848q0-16-16-16h-160q-16 0-16 16t16 16h160q16 0 16-16zm288-16v1024q0 52-38 90t-90 38h-512q-52 0-90-38t-38-90v-1024q0-52 38-90t90-38h512q52 0 90 38t38 90z"/></svg>			</div>
			<?php } ?>
			<?php if ($pagebuilderckParams->get('enablepanel_customcss', '1', 'int') !== '0') { ?>
			<div id="ckcustomcsssettingsbutton" data-target="customcss" class="menuckpanelfake cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_CUSTOMCSS') ?>" data-placement="right">
				<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 640 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M392.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6zm80.6 120.1c-12.5 12.5-12.5 32.8 0 45.3L562.7 256l-89.4 89.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-112-112c-12.5-12.5-32.8-12.5-45.3 0zm-306.7 0c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l112 112c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256l89.4-89.4c12.5-12.5 12.5-32.8 0-45.3z"/></svg>
			</div>
			<?php } ?>
		<?php } ?>
	</div>
	<div class="inner clearfix ckelementsedition menuckpaneltarget" data-target="addons">
		<div class="headerck">
			<span class="headercktext" style="width: 130px;"><?php echo \Joomla\CMS\Language\Text::_('CK_ELEMENTS'); ?></span>
			<span class="ckbutton-group" style="margin: 5px;">
				<span class="headerckdisplaytype ckbutton <?php echo ($displaytype == 'list' ? 'active' : '') ?>" data-type="list" onclick="ckSetAddonsDisplaytypeState('list')"><i class="fa fa-list cktip" data-placement="bottom" title="<?php echo \Joomla\CMS\Language\Text::_('CK_DISPLAY_TYPE_LIST') ?>" onclick="ckSearchAddon(this)"></i></span>
				<span class="headerckdisplaytype ckbutton <?php echo ($displaytype == 'grid' ? 'active' : '') ?>" data-type="grid" onclick="ckSetAddonsDisplaytypeState('grid')"><i class="fa fa-th cktip" data-placement="bottom" title="<?php echo \Joomla\CMS\Language\Text::_('CK_DISPLAY_TYPE_GRID') ?>" onclick="ckSearchAddon(this)"></i></span>
			</span>
		</div>
		<div id="ckaddonsearch" class="ckleftpanelsearch">
			<input type="text" class="cksearchleftpanel" placeholder="<?php echo \Joomla\CMS\Language\Text::_('CK_SEARCH') ?>" onchange="ckSearchAddon(this)" />
			<i class="fa fa-search cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SEARCH') ?>" onclick="ckSearchAddon(this)"></i>
			<i class="fa fa-times cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_CLEAN') ?>" onclick="ckSearchAddonClear()"></i>
		</div>
		<div class="menuckinfos"><?php echo \Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK_INSERT_CONTENT'); ?></div>
		<?php 
//		$items = Pagebuilderck\CKFof::triggerEvent( 'onPagebuilderckAddItemToMenu' );
		$items = PagebuilderckHelper::getPluginsMenuItemType();
		$groups = PagebuilderckHelper::getPluginsMenuItemTypeByGroup();
		$useTitle = (int)$pagebuilderckParams->get('tooltips', '1', 'int') === 1;
		?>
		<div id="ckaddonsdisplaytypegrid" class="ckaddonsdisplaytype">
		<?php
		$pagebuilderckTypesImagesArray = array();
		if (count($items)) {
			foreach ($items as $item) {
				$pagebuilderckTypesImagesArray[$item->type] = $item->image;
				?>
				<div data-type="<?php echo $item->type ?>" data-group="<?php echo $item->group ?>" class="menuitemck" <?php echo ($useTitle ? 'title="<b>' . $item->title . '</b><br />' . $item->description . '"' : '') ?>>
					<div>
						<div class="menuitemck_title"><?php echo $item->title ?></div>
					</div>
					<img src="<?php echo $item->image ?>" />
				</div>
				<?php
			}
		}
		?>
		</div>
		<div id="ckaddonsdisplaytypelist" class="ckaddonsdisplaytype">
		<?php
		foreach ($groups as $groupname => $group) {
			if (empty($group['items'])) continue;
			?>
			<div class="menuitemck_group"><?php echo $group['name'] ?></div>
			<div>
			<?php
			foreach ($group['items'] as $item) {
				$pagebuilderckTypesImagesArray[$item->type] = $item->image;
				?>
				<div data-type="<?php echo $item->type ?>" data-group="<?php echo $item->group ?>" class="menuitemck" <?php echo ($useTitle ? 'title="<b>' . $item->title . '</b><br />' . $item->description . '"' : '') ?>>
					<div>
						<div class="menuitemck_title"><?php echo $item->title ?></div>
					</div>
					<img src="<?php echo $item->image ?>" />
				</div>
				<?php
			}
			?>
			<div style="clear:both;"></div>
			</div>
		<?php
		}
		?>
		</div>
		<div style="clear:both;"></div>
		<div><?php echo PagebuilderckHelper::showParamsMessage(true, \Joomla\CMS\Language\Text::_('CK_PAGEBUILDERCK_GETMORE_PRO_ITEMS')); ?></div>
		<div class="headerck ckmyelements" style="clear:both;">
			<span class="headercktext"><?php echo \Joomla\CMS\Language\Text::_('CK_MY_ELEMENTS'); ?></span>
		</div>
		<div class="" id="ckmyelements">
			<?php 
			 $elements = PagebuilderckHelper::getElements();
			if (count($elements)) {
				foreach ($elements as $element) {
					if (($view == 'element' || $view == 'style') && $element->type == 'row') continue;
					$description = $element->description ? $element->description : $element->title;
					?>
					<div data-type="<?php echo $element->type ?>" data-id="<?php echo $element->id ?>" class="menuitemck ckmyelement" title="<b><?php echo $description ?></b>">
						<div>
							<div class="menuitemck_title"><?php echo $element->title ?></div>
						</div>
						<img src="<?php echo isset($pagebuilderckTypesImagesArray[$element->type]) ? $pagebuilderckTypesImagesArray[$element->type] : PAGEBUILDERCK_MEDIA_URI . '/images/contents/' . $element->type . '.svg' ?>" />
					</div>
					<?php
				}
			}
			?>
		</div>
	</div>
	<div class="inner clearfix ckelementsedition menuckpaneltarget" data-target="pages">
		<div class="headerck">
			<span class="headercktext"><?php echo \Joomla\CMS\Language\Text::_('CK_PAGES'); ?></span>
		</div>
		<iframe class="ckwait" src="index.php?option=com_pagebuilderck&view=pages&layout=modal&tmpl=component&function=returnLoadPage&target=leftpanel" width="100%" height="auto" >
		</iframe>
	</div>
	<div class="inner clearfix ckelementsedition menuckpaneltarget" data-target="styles">
		<div class="headerck">
			<span class="headercktext"><?php echo \Joomla\CMS\Language\Text::_('CK_STYLES'); ?></span>
		</div>
		<?php if (PagebuilderckHelper::getParams()) { ?>
		<iframe id="pbckiframestyles" class="ckwait" src="index.php?option=com_pagebuilderck&view=styles&layout=modal&tmpl=component&function=ckReturnLoadStyle&target=leftpanel" width="100%" height="auto" >
		</iframe>
		<?php } else {
			echo PagebuilderckHelper::showParamsMessage();
		}
		?>
	</div>
	<div class="inner clearfix ckelementsedition menuckpaneltarget" data-target="library">
		<div class="headerck">
			<span class="headercktext"><?php echo \Joomla\CMS\Language\Text::_('CK_MODELS'); ?></span>
		</div>
		<?php if (PagebuilderckHelper::getParams()) { ?>
		<div id="cklibraryiframe"><?php PagebuilderckHelper::loadCustomLibrary() ?></div>
		<?php } else {
			echo PagebuilderckHelper::showParamsMessage();
		}
		?>
	</div>
	<div class="inner clearfix ckresponsiveedition menuckpaneltarget" data-target="responsive">
		<div class="menuckcollapse headerck">
			<span class="headercktext" style="width:auto;"><?php echo \Joomla\CMS\Language\Text::_('CK_RESPONSIVE_SETTINGS'); ?></span>
			<?php /*<span class="headerckicon cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SAVE_CLOSE'); ?>" onclick="ckShowResponsiveSettings(true);">×</span> */ ?>
		</div>
		<div id="cktoolbarResponsive" class="clearfix ckinterface cktoolbarResponsive" style="overflow:visible;background:none;padding:5px;">
			<span class="ckbutton-group">
				<span id="ckresponsive1button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(1)" data-range="1">
					<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M976 1408q0-33-23.5-56.5t-56.5-23.5-56.5 23.5-23.5 56.5 23.5 56.5 56.5 23.5 56.5-23.5 23.5-56.5zm208-160v-704q0-13-9.5-22.5t-22.5-9.5h-512q-13 0-22.5 9.5t-9.5 22.5v704q0 13 9.5 22.5t22.5 9.5h512q13 0 22.5-9.5t9.5-22.5zm-192-848q0-16-16-16h-160q-16 0-16 16t16 16h160q16 0 16-16zm288-16v1024q0 52-38 90t-90 38h-512q-52 0-90-38t-38-90v-1024q0-52 38-90t90-38h512q52 0 90 38t38 90z"/></svg>
					 <?php echo \Joomla\CMS\Language\Text::_('CK_PHONE') ?> / <small><?php echo \Joomla\CMS\Language\Text::_('CK_PORTRAIT') ?></small></span>
				<input id="ckresponsive1value" type="text" value="<?php echo $componentParams->get('responsive1value', '320') ?>" data-default="" disabled="disabled" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SET_RESPONSIVE_VALUE_IN_OPTIONS') ?>" style="width:40px;"/>
			</span>
			<span class="ckbutton-group">
				<span id="ckresponsive2button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(2)" data-range="2">
					<svg style="vertical-align: bottom;transform:rotate(90deg);" width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M976 1408q0-33-23.5-56.5t-56.5-23.5-56.5 23.5-23.5 56.5 23.5 56.5 56.5 23.5 56.5-23.5 23.5-56.5zm208-160v-704q0-13-9.5-22.5t-22.5-9.5h-512q-13 0-22.5 9.5t-9.5 22.5v704q0 13 9.5 22.5t22.5 9.5h512q13 0 22.5-9.5t9.5-22.5zm-192-848q0-16-16-16h-160q-16 0-16 16t16 16h160q16 0 16-16zm288-16v1024q0 52-38 90t-90 38h-512q-52 0-90-38t-38-90v-1024q0-52 38-90t90-38h512q52 0 90 38t38 90z"/></svg>
					 <?php echo \Joomla\CMS\Language\Text::_('CK_PHONE') ?> / <small><?php echo \Joomla\CMS\Language\Text::_('CK_LANDSCAPE') ?></small></span>
				<input id="ckresponsive2value" type="text" value="<?php echo $componentParams->get('responsive2value', '480') ?>" class="cktip" data-default="" disabled="disabled" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SET_RESPONSIVE_VALUE_IN_OPTIONS') ?>" style="width:40px;"/>
			</span>
			<span class="ckbutton-group">
				<span id="ckresponsive3button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(3)" data-range="3">
					<svg width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M960 1408q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm384-160v-960q0-13-9.5-22.5t-22.5-9.5h-832q-13 0-22.5 9.5t-9.5 22.5v960q0 13 9.5 22.5t22.5 9.5h832q13 0 22.5-9.5t9.5-22.5zm128-960v1088q0 66-47 113t-113 47h-832q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h832q66 0 113 47t47 113z"/></svg>
					 <?php echo \Joomla\CMS\Language\Text::_('CK_TABLET') ?> / <small><?php echo \Joomla\CMS\Language\Text::_('CK_PORTRAIT') ?></small></span>
				<input id="ckresponsive3value" type="text" value="<?php echo $componentParams->get('responsive3value', '640') ?>" class="cktip" data-default="" disabled="disabled" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SET_RESPONSIVE_VALUE_IN_OPTIONS') ?>" style="width:40px;"/>
			</span>
			<span class="ckbutton-group">
				<span id="ckresponsive4button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(4)" data-range="4">
					<svg style="vertical-align: bottom;transform:rotate(90deg);" width="1792" height="1792" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M960 1408q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm384-160v-960q0-13-9.5-22.5t-22.5-9.5h-832q-13 0-22.5 9.5t-9.5 22.5v960q0 13 9.5 22.5t22.5 9.5h832q13 0 22.5-9.5t9.5-22.5zm128-960v1088q0 66-47 113t-113 47h-832q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h832q66 0 113 47t47 113z"/></svg>
					 <?php echo \Joomla\CMS\Language\Text::_('CK_TABLET') ?> / <small><?php echo \Joomla\CMS\Language\Text::_('CK_LANDSCAPE') ?></small></span>
				<input id="ckresponsive4value" type="text" value="<?php echo $componentParams->get('responsive4value', '800') ?>" class="cktip" data-default="" disabled="disabled" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SET_RESPONSIVE_VALUE_IN_OPTIONS') ?>" style="width:40px;"/>
			</span>
			<span>
				<span id="ckresponsive5button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(5)" data-range="5">
					<svg width="2048" height="1792" viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1856 992v-832q0-13-9.5-22.5t-22.5-9.5h-1600q-13 0-22.5 9.5t-9.5 22.5v832q0 13 9.5 22.5t22.5 9.5h1600q13 0 22.5-9.5t9.5-22.5zm128-832v1088q0 66-47 113t-113 47h-544q0 37 16 77.5t32 71 16 43.5q0 26-19 45t-45 19h-512q-26 0-45-19t-19-45q0-14 16-44t32-70 16-78h-544q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h1600q66 0 113 47t47 113z"/></svg>
					 <?php echo \Joomla\CMS\Language\Text::_('CK_COMPUTER') ?>
				</span>
			</span>
			<p><?php echo \Joomla\CMS\Language\Text::_('CK_EDIT_RESPONSIVE_COLUMNS_DESC') ?></p>
			<div class="ckinterface">
				<span class="ckbuttonstyle" onclick="ckSwitchResponsiveEditColumns(this)" data-state="0">
					<svg style="width:20px;height:24px;stroke:#fff;vertical-align: bottom;" xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-columns-2" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
					<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
					<path d="M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1zm9 -1v18" />
					</svg>
					<?php echo \Joomla\CMS\Language\Text::_('CK_EDIT_RESPONSIVE_COLUMNS') ?>
				</span>
			</div>
		</div>
	</div>
	<div class="inner clearfix ckcolumnsedition" >
		<div class="headerck">
			<span class="headerckicon" onclick="ckHideColumnsEdition()">×</span>
			<span class="headercktext"><?php echo \Joomla\CMS\Language\Text::_('CK_COLUMNS'); ?></span>
		</div>
		<div class="ckcolumnsoptions">
			<div class="ckbutton-group" style="margin-top: 5px;">
				<input id="autowidth" name="autowidth" value="1" type="radio" onchange="ckUpdateAutowidth($ck('.rowck.ckfocus'), this.value);" />
				<label class="ckbutton btn" for="autowidth" style="width:auto;margin-left:5px;" ><?php echo \Joomla\CMS\Language\Text::_('CK_AUTO_WIDTH') ?></label>
				<input id="advlayout" name="autowidth" value="0" type="radio" onchange="ckUpdateAutowidth($ck('.rowck.ckfocus'), this.value);" />
				<label class="ckbutton btn" for="advlayout" style="width:auto;"><?php echo \Joomla\CMS\Language\Text::_('CK_ADVANCED_LAYOUT') ?></label>
			</div>
			<div id="ckgutteroptions">
				<div class="menuckinfos"><?php echo \Joomla\CMS\Language\Text::_('CK_GUTTER') ?></div>
				<input class="ckguttervalue" type="text" onchange="ckUpdateGutter($ck('.rowck.ckfocus'), this.value);" style="margin-left:5px;" />
			</div>
			<div>
				<div class="ckbuttonstyle" onclick="ckAddBlock($ck('.rowck.ckfocus'));" style="display: block;">+ <?php echo \Joomla\CMS\Language\Text::_('CK_ADD_COLUMN') ?></div>
			</div>
			<div class="menuckinfos"><?php echo \Joomla\CMS\Language\Text::_('CK_COLUMNS_SPACE_BETWEEN') ?></div>
			<div class="ckbutton-group" style="margin-top: 5px;">
				<input id="columns-space-between0" name="columns-space-between" value="0" type="radio" onchange="ckUpdateSpacebetween($ck('.rowck.ckfocus'), this.value);" />
				<label class="ckbutton btn" for="columns-space-between0" style="width:auto;margin-left:5px;" ><?php echo \Joomla\CMS\Language\Text::_('JNO') ?></label>
				<input id="columns-space-between1" name="columns-space-between" value="1" type="radio" onchange="ckUpdateSpacebetween($ck('.rowck.ckfocus'), this.value);" />
				<label class="ckbutton btn" for="columns-space-between1" style="width:auto;"><?php echo \Joomla\CMS\Language\Text::_('JYES') ?></label>
			</div>
			<div id="ckcolumnsuggestions">

			</div>
		</div>
	</div>
	<div class="menuckbootomtoolbar">
		<span id="togglepanel" class="menuckbootomtoolbar-button cktip" onclick="ckTogglePanel()" title="<?php echo \Joomla\CMS\Language\Text::_('CK_TOGGLE_PANEL') ?>">
		<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M15 6l-6 6l6 6" />
</svg>
		</span>
		<?php if ($input->get('id', 0, 'int') 
				&& $input->get('option', '', 'cmd') == 'com_pagebuilderck' 
				&& $input->get('view', '', 'cmd') == 'page' 
				&& \Pagebuilderck\CKFof::isAdmin()){ ?>
		<a class="" target="_blank" href="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/index.php?option=com_pagebuilderck&view=page&id=<?php echo $input->get('id', '', 'int') ?>"><span class="menuckbootomtoolbar-button cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_PREVIEW_FRONT') ?>">
		<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-check" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
  <path d="M11.143 17.961c-3.221 -.295 -5.936 -2.281 -8.143 -5.961c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.222 .37 -.449 .722 -.68 1.057" />
  <path d="M15 19l2 2l4 -4" />
</svg>
		</a>
		<?php } else if ($input->get('id', 0, 'int') && $input->get('option', '', 'cmd') == 'com_content' && $input->get('view', '', 'cmd') == 'article' && \Pagebuilderck\CKFof::isAdmin()) { ?>
		<a class="" target="_blank" href="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/index.php?option=com_content&view=article&id=<?php echo $input->get('id', '', 'int') ?>"><span class="menuckbootomtoolbar-button cktip" title="<?php echo \Joomla\CMS\Language\Text::_('CK_PREVIEW_FRONT') ?>">
		<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-check" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
  <path d="M11.143 17.961c-3.221 -.295 -5.936 -2.281 -8.143 -5.961c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6c-.222 .37 -.449 .722 -.68 1.057" />
  <path d="M15 19l2 2l4 -4" />
</svg>
		</a>
		<?php }?>
		<?php if ( 
				($input->get('option', '', 'cmd') == 'com_content' && $input->get('view', '', 'cmd') == 'article' && \Pagebuilderck\CKFof::isAdmin())
			|| ($input->get('option', '', 'cmd') == 'com_flexicontent' && $input->get('view', '', 'cmd') == 'article' && \Pagebuilderck\CKFof::isAdmin())
			|| ($input->get('option', '', 'cmd') == 'com_modules' && $input->get('view', '', 'cmd') == 'module' && \Pagebuilderck\CKFof::isAdmin())
			|| ($input->get('option', '', 'cmd') == 'com_advmodulesmanager' && $input->get('view', '', 'cmd') == 'module' && \Pagebuilderck\CKFof::isAdmin())
				) { ?>
		<span class="menuckbootomtoolbar-button cktip" onclick="ckSaveAsPage()" title="<?php echo \Joomla\CMS\Language\Text::_('CK_SAVE_AS_PAGE') ?>">
		<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-device-floppy" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" />
  <path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
  <path d="M14 4l0 4l-6 0l0 -4" />
</svg>
		</span>
		<?php } ?>
		<span id="ckhtmlchecksettingsbutton" class="menuckbootomtoolbar-button cktip" onclick="ckCheckHtml()" title="<?php echo \Joomla\CMS\Language\Text::_('CK_HTML_CSS') ?>">
<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-focus" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <circle cx="12" cy="12" r=".5" fill="currentColor" />
  <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
</svg>
		</span>
		<span id="ckundo" class="menuckbootomtoolbar-button cktip" onclick="ckUndo()" title="<?php echo \Joomla\CMS\Language\Text::_('CK_UNDO') ?>">
			<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-back-up" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
				<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
				<path d="M9 14l-4 -4l4 -4" />
				<path d="M5 10h11a4 4 0 1 1 0 8h-1" />
			  </svg>
		</span>
		<span id="ckundo" class="menuckbootomtoolbar-button cktip" onclick="ckRedo()" title="<?php echo \Joomla\CMS\Language\Text::_('CK_REDO') ?>">
			<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-forward-up" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#2c3e50" fill="none" stroke-linecap="round" stroke-linejoin="round">
				<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
				<path d="M15 14l4 -4l-4 -4" />
				<path d="M19 10h-11a4 4 0 1 0 0 8h1" />
			  </svg>
		</span>
	</div>
	<div id="ckcustomcssedition" style="display: none;"></div>
</div>
<?php 
// if contenttype, only load the plugins with scripts
} else {
	// load the custom plugins
	\Joomla\CMS\Plugin\PluginHelper::importPlugin( 'pagebuilderck' );
	$otheritems = Pagebuilderck\CKFof::triggerEvent( 'onPagebuilderckAddItemToMenu' );
}
?>
<script type="text/javascript">
// check if we are in frontend
var isSiteCK = '<?php echo \Pagebuilderck\CKFof::isSite() ?>';
$ck('#menuck').hide();

var ckcustomcsseditor;
$ck(document).ready(function (){
	// create tooltip for the items
	ckMakeTooltip($ck('#menuck .menuitemck'));
	$ck('#menuck').fadeIn();
});

if (isSiteCK) {
	$ck(window).on("load resize scroll", function() {
		if (! $ck('#workspaceck').length || ! $ck('#workspaceparentck').length) return;
		var menuToWorkspaceOffset = $ck('#workspaceparentck').offset().left -50 - $ck('#menuck').width()
		if (menuToWorkspaceOffset < 0) {
			$ck('#workspaceck').css({'margin-left': -menuToWorkspaceOffset + 'px'});
		} else {
			$ck('#workspaceck').css({'margin-left': '0'});
		}
	});
}

$ck('.menuckpanel').click(function() {
	ckActivatePanel($ck(this).attr('data-target'));
});

$ck('#ckcustomcsssettingsbutton').click(function() {
	ckOpenCustomCssEditor();
});

$ck('.menuitemck_group').click(function() {
	$ck(this).find('+ div').toggle('fast');
});

</script>