<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Pagebuilderck\CKView;
use Pagebuilderck\CKFof;

/**
 * View class for a list of items.
 */
class PagebuilderckViewPages extends CKView {

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		// for the items published to be shown in the modal list
		$this->state = $this->model->getState();
		if ($this->input->get('layout') === 'modal') {
			$this->model->setState('filter_state', '1');
		} else {
			$this->model->setState('filter_state', '');
		}

		$this->items = $this->get('Items');

		if (CKFof::isAdmin()) $this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		PagebuilderckHelper::loadCkbox();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		// Load the left sidebar only for Joomla 3 and under.
		if (! PAGEBUILDERCK_ISJ4) {
			PagebuilderckHelper::addSubmenu('pages');
		}

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK'));

		if (CKFof::userCan('create')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::addNew('page.add', 'JTOOLBAR_NEW');
		}

		if (CKFof::userCan('edit')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::editList('page.edit', 'JTOOLBAR_EDIT');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('page.copy', 'copy', 'copy', 'CK_COPY');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('page.publish', 'publish', 'publish', 'JTOOLBAR_PUBLISH');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('page.unpublish', 'unpublish', 'unpublish', 'JTOOLBAR_UNPUBLISH');
			// if Params is installed
			if (PagebuilderckHelper::getParams()) {
				$importButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="CKBox.open({handler: \'inline\', content: \'ckImportModal\', fullscreen: false, size: {x: \'600px\', y: \'200px\'}});">
									<span class="icon-forward-2"></span>
									' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
								</button></joomla-toolbar-button>';
				$bar->appendButton('Custom', $importButton, 'import');

//				$exportButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
//									<span class="icon-share"></span>
//									' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
//								</button></joomla-toolbar-button>';
//				$bar->appendButton('Custom', $exportButton, 'export');

				if (version_compare(JVERSION, '4.0.0') > 0) {
					$exportButton = '<div id="toolbar-dropdown-save-group" class="btn-group dropdown-save-group" role="group">
									<joomla-toolbar-button>
										<button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
											<span class="icon-share"></span>
											' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
										</button>
									</joomla-toolbar-button>
									<button type="button" class="btn dropdown-toggle-split" data-bs-toggle="dropdown" data-bs-target=".dropdown-menu" data-bs-display="static" aria-haspopup="true" aria-expanded="false">
										<span class="visually-hidden">Toggle Dropdown</span>
										<span class="icon-chevron-down" aria-hidden="true"></span>
									</button>
									<div class="dropdown-menu ">
										<joomla-toolbar-button>
											<button class=" dropdown-item first" type="button" onclick="ckExportPage(document.adminForm, \'1\');">
												<span class="icon-share"></span>
											' . \Joomla\CMS\Language\Text::_('CK_EXPORT_WITH_IMAGES') . '
											</button>
										</joomla-toolbar-button>
										<joomla-toolbar-button>
											<button class=" dropdown-item first" type="button" onclick="ckExportPageAsLibrary(document.adminForm);">
												<span class="icon-share"></span>
											' . \Joomla\CMS\Language\Text::_('CK_EXPORT_AS_LIBRARY') . '
											</button>
										</joomla-toolbar-button>
									</div>
								</div>';
					$bar->appendButton('Custom', $exportButton, 'export');
				} else {
					$exportButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
								</button></joomla-toolbar-button>';
					$bar->appendButton('Custom', $exportButton, 'export');

					$exportButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="ckExportPage(document.adminForm, \'1\');">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT_WITH_IMAGES') . '
								</button></joomla-toolbar-button>';
					$bar->appendButton('Custom', $exportButton, 'export');

					$exportButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="ckExportPageAsLibrary(document.adminForm);">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT_AS_LIBRARY') . '
								</button></joomla-toolbar-button>';
					$bar->appendButton('Custom', $exportButton, 'export');
				}

				/*
				 * <div id="toolbar-dropdown-save-group" class="btn-group dropdown-save-group" role="group">
            <button type="button" class="btn btn-success dropdown-toggle-split" data-bs-toggle="dropdown" data-bs-target=".dropdown-menu" data-bs-display="static" aria-haspopup="true" aria-expanded="false">
                <span class="visually-hidden">Toggle Dropdown</span>
                <span class="icon-chevron-down" aria-hidden="true"></span>
            </button>

            
<joomla-toolbar-button id="save-group-children-save" task="article.save" form-validation="">
<button class="button-save btn btn-success" type="button">
    <span class="icon-save" aria-hidden="true"></span>
    Save &amp; Close</button>
</joomla-toolbar-button>

                            <div class="dropdown-menu ">
                    
<joomla-toolbar-button id="save-group-children-save-new" task="article.save2new" form-validation="">
<button class="button-save-new  dropdown-item first" type="button">
    <span class="icon-save-new" aria-hidden="true"></span>
    Save &amp; New</button>
</joomla-toolbar-button>

<joomla-toolbar-button id="save-group-children-save1" task="article.save2menu" form-validation="">
<button class="button-save  dropdown-item" type="button">
    <span class="icon-save" aria-hidden="true"></span>
    Save to Menu</button>
</joomla-toolbar-button>

<joomla-toolbar-button id="save-group-children-save-copy" task="article.save2copy" form-validation="">
<button class="button-save-copy  dropdown-item last" type="button">
    <span class="icon-save-copy" aria-hidden="true"></span>
    Save as Copy</button>
</joomla-toolbar-button>
                </div>
                    </div>
				 */
				// if (document.adminForm.boxchecked.value==0){alert('Veuillez d\'abord effectuer une s�lection dans la liste.');}else{ Joomla.submitbutton('pages.export')}
				// \Joomla\CMS\Toolbar\ToolbarHelper::custom('pages.export', 'share', 'share', 'CK_EXPORT', true);
				if ($importClass = PagebuilderckHelper::getParams('import')) {
					$importClass->loadImportForm();
				}
				if ($exportClass = PagebuilderckHelper::getParams('export')) {
					$exportClass->loadExportForm();
				}
			} else {
				$importButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
									<span class="icon-forward-2"></span>
									' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
								</button></joomla-toolbar-button>';
				$bar->appendButton('Custom', $importButton, 'import');
				$exportButton = '<joomla-toolbar-button><button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
								</button></joomla-toolbar-button>';
				$bar->appendButton('Custom', $exportButton, 'export');
				echo PagebuilderckHelper::showParamsMessage(false);
			}
		}

		if (CKFof::userCan('core.delete')) {
			//If this component does not use state then show a direct delete button as we can not trash
			// \Joomla\CMS\Toolbar\ToolbarHelper::custom('page.trash', 'trash', 'trash', 'JTOOLBAR_DELETE', 'test');
			$deleteButton = '<joomla-toolbar-button id="toolbar-cktrash" list-selection=""><button class="btn btn-small ' . (PAGEBUILDERCK_ISJ4 ? 'btn-danger' : '') . '" onclick="if (document.adminForm.boxchecked.value == 0) { alert(Joomla.JText._(\'JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST\')); } else { if (confirm(\'' . \Joomla\CMS\Language\Text::_('CK_CONFIRM_DELETE') . '\')) Joomla.submitbutton(\'page.trash\'); }">
									<span class="icon-trash"></span>
									' . \Joomla\CMS\Language\Text::_('CK_DELETE') . '
								</button></joomla-toolbar-button>';
			$bar->appendButton('Custom', $deleteButton, 'export');
		}

		if (CKFof::userCan('core.admin')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::preferences('com_pagebuilderck');
		}
	}
}
