<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Pagebuilderck\CKView;
use Pagebuilderck\CKFof;

/**
 * View class for a list of Templateck.
 */
class PagebuilderckViewStyles extends CKView {

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		// for the items published to be shown in the modal list
		$this->state = $this->model->getState();
		if ($this->input->get('layout') === 'modal') {
			$this->model->setState('filter_state', '1');
		} else {
			$this->model->setState('filter_state', '');
		}

		$this->items = $this->get('Items');

		if (CKFof::isAdmin()) $this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar() {
		PagebuilderckHelper::loadCkbox();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		// Load the left sidebar only for Joomla 3 and under.
		if (! PAGEBUILDERCK_ISJ4) {
			PagebuilderckHelper::addSubmenu('styles');
		}

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_PAGEBUILDERCK'));

		if (CKFof::userCan('create')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::addNew('style.add', 'JTOOLBAR_NEW');
		}

		if (CKFof::userCan('edit')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::editList('style.edit', 'JTOOLBAR_EDIT');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('style.copy', 'copy', 'copy', 'CK_COPY');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('style.publish', 'publish', 'publish', 'JTOOLBAR_PUBLISH');
			\Joomla\CMS\Toolbar\ToolbarHelper::custom('style.unpublish', 'unpublish', 'unpublish', 'JTOOLBAR_UNPUBLISH');
			// if Params is installed
			if (PagebuilderckHelper::getParams()) {
				$importButton = '<button class="btn btn-small" onclick="CKBox.open({handler: \'inline\', content: \'ckImportModal\', fullscreen: false, size: {x: \'600px\', y: \'200px\'}});">
									<span class="icon-forward-2"></span>
									' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
								</button>';
				$bar->appendButton('Custom', $importButton, 'import');

				$exportButton = '<button class="btn btn-small" onclick="ckExportPage(document.adminForm);">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
								</button>';
				$bar->appendButton('Custom', $exportButton, 'export');

				// if (document.adminForm.boxchecked.value==0){alert('Veuillez d\'abord effectuer une s�lection dans la liste.');}else{ Joomla.submitbutton('pages.export')}
				// \Joomla\CMS\Toolbar\ToolbarHelper::custom('pages.export', 'share', 'share', 'CK_EXPORT', true);
				if ($importClass = PagebuilderckHelper::getParams('import')) {
					$importClass->loadImportForm();
				}
				if ($exportClass = PagebuilderckHelper::getParams('export')) {
					$exportClass->loadExportForm();
				}
			} else {
				$importButton = '<button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
									<span class="icon-forward-2"></span>
									' . \Joomla\CMS\Language\Text::_('CK_IMPORT') . '
								</button>';
				$bar->appendButton('Custom', $importButton, 'import');
				$exportButton = '<button class="btn btn-small" onclick="CKBox.open({handler:\'inline\',content: \'pagebuilderckparamsmessage\', fullscreen: false, size: {x: \'600px\', y: \'150px\'}});">
									<span class="icon-share"></span>
									' . \Joomla\CMS\Language\Text::_('CK_EXPORT') . '
								</button>';
				$bar->appendButton('Custom', $exportButton, 'export');
				echo PagebuilderckHelper::showParamsMessage(false);
			}
		}

		if (CKFof::userCan('core.delete')) {
			//If this component does not use state then show a direct delete button as we can not trash
			\Joomla\CMS\Toolbar\ToolbarHelper::trash('style.trash');
		}

		if (CKFof::userCan('core.admin')) {
			\Joomla\CMS\Toolbar\ToolbarHelper::preferences('com_pagebuilderck');
		}
	}
}
