<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class PagebuilderckViewFrontedition extends \Joomla\CMS\MVC\View\HtmlView
{
	protected $item;

	protected $state;

	public function display($tpl = null)
	{

		// check that the user has the rights to edit
		$user = \Joomla\CMS\Factory::getUser();
		$app = \Joomla\CMS\Factory::getApplication();
		$authorised = ($user->authorise('core.create', 'com_pagebuilderck') || (count($user->getAuthorisedCategories('com_pagebuilderck', 'core.create'))));
		if ($authorised !== true)
		{
			if ($user->guest === 1)
			{
				$return = base64_encode(\Joomla\CMS\Uri\Uri::getInstance());
				$login_url_with_return = \Joomla\CMS\Router\Route::_('index.php?option=com_users&return=' . $return);
				$app->enqueueMessage(\Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'), 'notice');
				$app->redirect($login_url_with_return, 403);
			}
			else
			{
				$app->enqueueMessage(\Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'), 'error');
				$app->setHeader('status', 403, true);
				return;
			}
			// JError::raiseError(403, \Joomla\CMS\Language\Text::_('JERROR_ALERTNOAUTHOR'));
			// return false;
		}

		// check that the template is compatible
		$app    = \Joomla\CMS\Factory::getApplication();
		$template = $app->getTemplate();
		$this->input = $app->input;

		// load xml file from the template
		$xml = simplexml_load_file(JPATH_SITE . '/templates/' . $template . '/templateDetails.xml');

		// check that the template is made with a compatible version of Template Creator CK
		if ($xml->generator != 'Template Creator CK') {
			JError::raiseWarning(403, \Joomla\CMS\Language\Text::_('The template you are trying to edit has not been created with Template Creator CK, or not the latest version of if. You can download Template Creator CK on <a href="https://www.template-creator.com">https://www.template-creator.com</a>'));
			return;
		}

		return parent::display($tpl);
	}
}
