<?php
/**
 * @name		Page Builder CK
 * @package		com_pagebuilderck
 * @copyright	Copyright (C) 2015. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

$user = \Joomla\CMS\Factory::getUser();
$canEdit = $user->authorise('core.edit.own', 'com_pagebuilderck');

// frontend medias
PagebuilderckFrontHelper::loadFrontendAssets();

// load the component configuration
$params = \Joomla\CMS\Component\ComponentHelper::getParams('com_pagebuilderck');
// load the page/link configuration
$app = \Joomla\CMS\Factory::getApplication();
$pageParams = $app->getParams();
$doc = \Joomla\CMS\Factory::getDocument();

// add the meta in the page
if ($pageParams->get('menu-meta_description'))
{
	$doc->setDescription($pageParams->get('menu-meta_description'));
}
if ($pageParams->get('menu-meta_keywords'))
{
	$doc->setMetadata('keywords', $pageParams->get('menu-meta_keywords'));
}
if ($pageParams->get('robots'))
{
	$doc->setMetadata('robots', $pageParams->get('robots'));
}
// $this->item->params = new \Joomla\Registry\Registry($this->item->params);
?>
<div class="pagebuilderck <?php echo htmlspecialchars($pageParams->get('pageclass_sfx', '')); ?>">
	<?php if ($canEdit && $this->input->get('option', '', 'cmd') == 'com_pagebuilderck' ) { ?>
		<a class="btn btn-primary" href="<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/index.php?option=com_pagebuilderck&task=page.edit&id=<?php echo $this->item->id ?>"><i class="icon icon-edit"></i> <?php echo \Joomla\CMS\Language\Text::_('CK_EDIT') ?></a>
	<?php } ?>

	<?php if ($pageParams->get('show_page_heading', '1') && $pageParams->get('page_heading')) { ?>
		<div class="page-header">
			<h1> <?php echo addslashes($pageParams->get('page_heading')); ?> </h1>
		</div>
	<?php } ?>

	<?php if ($this->item->params->get('showtitle')) { ?>
		<<?php echo $this->item->params->get('titletag', 'h1') ?> class="pagebuilderck_title"><?php echo $this->item->title ?></<?php echo $this->item->params->get('titletag', 'h1') ?>>
	<?php } ?>

	<?php echo $this->item->htmlcode; ?>
</div>
